/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.simpledb.AmazonSimpleDBAsync;
import com.amazonaws.services.simpledb.AmazonSimpleDBClient;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.CreateDomainRequest;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeleteDomainRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataRequest;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.services.simpledb.model.GetAttributesResult;
import com.amazonaws.services.simpledb.model.ListDomainsRequest;
import com.amazonaws.services.simpledb.model.ListDomainsResult;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.SelectRequest;
import com.amazonaws.services.simpledb.model.SelectResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonSimpleDBAsyncClient
extends AmazonSimpleDBClient
implements AmazonSimpleDBAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonSimpleDBAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonSimpleDBAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials aWSCredentials) {
        this(aWSCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials aWSCredentials, ExecutorService executorService) {
        super(aWSCredentials);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentials aWSCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider) {
        this(aWSCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ExecutorService executorService) {
        this(aWSCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(aWSCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSimpleDBAsyncClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(aWSCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<SelectResult> selectAsync(final SelectRequest selectRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SelectResult>(){

            @Override
            public SelectResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.select(selectRequest);
            }
        });
    }

    @Override
    public Future<SelectResult> selectAsync(final SelectRequest selectRequest, final AsyncHandler<SelectRequest, SelectResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SelectResult>(){

            @Override
            public SelectResult call() throws Exception {
                SelectResult selectResult;
                try {
                    selectResult = AmazonSimpleDBAsyncClient.this.select(selectRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)selectRequest, (Object)selectResult);
                return selectResult;
            }
        });
    }

    @Override
    public Future<Void> putAttributesAsync(final PutAttributesRequest putAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.putAttributes(putAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putAttributesAsync(final PutAttributesRequest putAttributesRequest, final AsyncHandler<PutAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.putAttributes(putAttributesRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)putAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchDeleteAttributesAsync(final BatchDeleteAttributesRequest batchDeleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.batchDeleteAttributes(batchDeleteAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchDeleteAttributesAsync(final BatchDeleteAttributesRequest batchDeleteAttributesRequest, final AsyncHandler<BatchDeleteAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.batchDeleteAttributes(batchDeleteAttributesRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchDeleteAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.deleteDomain(deleteDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDomainAsync(final DeleteDomainRequest deleteDomainRequest, final AsyncHandler<DeleteDomainRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.deleteDomain(deleteDomainRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteDomainRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createDomainAsync(final CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.createDomain(createDomainRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> createDomainAsync(final CreateDomainRequest createDomainRequest, final AsyncHandler<CreateDomainRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.createDomain(createDomainRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createDomainRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.deleteAttributes(deleteAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAttributesAsync(final DeleteAttributesRequest deleteAttributesRequest, final AsyncHandler<DeleteAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.deleteAttributes(deleteAttributesRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(final ListDomainsRequest listDomainsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.listDomains(listDomainsRequest);
            }
        });
    }

    @Override
    public Future<ListDomainsResult> listDomainsAsync(final ListDomainsRequest listDomainsRequest, final AsyncHandler<ListDomainsRequest, ListDomainsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDomainsResult>(){

            @Override
            public ListDomainsResult call() throws Exception {
                ListDomainsResult listDomainsResult;
                try {
                    listDomainsResult = AmazonSimpleDBAsyncClient.this.listDomains(listDomainsRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDomainsRequest, (Object)listDomainsResult);
                return listDomainsResult;
            }
        });
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(final GetAttributesRequest getAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetAttributesResult>(){

            @Override
            public GetAttributesResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.getAttributes(getAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetAttributesResult> getAttributesAsync(final GetAttributesRequest getAttributesRequest, final AsyncHandler<GetAttributesRequest, GetAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetAttributesResult>(){

            @Override
            public GetAttributesResult call() throws Exception {
                GetAttributesResult getAttributesResult;
                try {
                    getAttributesResult = AmazonSimpleDBAsyncClient.this.getAttributes(getAttributesRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getAttributesRequest, (Object)getAttributesResult);
                return getAttributesResult;
            }
        });
    }

    @Override
    public Future<Void> batchPutAttributesAsync(final BatchPutAttributesRequest batchPutAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSimpleDBAsyncClient.this.batchPutAttributes(batchPutAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> batchPutAttributesAsync(final BatchPutAttributesRequest batchPutAttributesRequest, final AsyncHandler<BatchPutAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonSimpleDBAsyncClient.this.batchPutAttributes(batchPutAttributesRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)batchPutAttributesRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(final DomainMetadataRequest domainMetadataRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainMetadataResult>(){

            @Override
            public DomainMetadataResult call() throws Exception {
                return AmazonSimpleDBAsyncClient.this.domainMetadata(domainMetadataRequest);
            }
        });
    }

    @Override
    public Future<DomainMetadataResult> domainMetadataAsync(final DomainMetadataRequest domainMetadataRequest, final AsyncHandler<DomainMetadataRequest, DomainMetadataResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DomainMetadataResult>(){

            @Override
            public DomainMetadataResult call() throws Exception {
                DomainMetadataResult domainMetadataResult;
                try {
                    domainMetadataResult = AmazonSimpleDBAsyncClient.this.domainMetadata(domainMetadataRequest);
                }
                catch (Exception exception) {
                    asyncHandler.onError(exception);
                    throw exception;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)domainMetadataRequest, (Object)domainMetadataResult);
                return domainMetadataResult;
            }
        });
    }
}

