/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.DeletableItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchDeleteAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private ListWithAutoConstructFlag<DeletableItem> items;

    public BatchDeleteAttributesRequest() {
    }

    public BatchDeleteAttributesRequest(String string, List<DeletableItem> list) {
        this.setDomainName(string);
        this.setItems(list);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public BatchDeleteAttributesRequest withDomainName(String string) {
        this.domainName = string;
        return this;
    }

    public List<DeletableItem> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<DeletableItem> collection) {
        if (collection == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.items = listWithAutoConstructFlag;
    }

    public BatchDeleteAttributesRequest withItems(DeletableItem ... deletableItemArray) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<DeletableItem>(deletableItemArray.length));
        }
        for (DeletableItem deletableItem : deletableItemArray) {
            this.getItems().add(deletableItem);
        }
        return this;
    }

    public BatchDeleteAttributesRequest withItems(Collection<DeletableItem> collection) {
        if (collection == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.items = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getDomainName() != null) {
            stringBuilder.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItems() != null) {
            stringBuilder.append("Items: " + this.getItems());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        n = 31 * n + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BatchDeleteAttributesRequest)) {
            return false;
        }
        BatchDeleteAttributesRequest batchDeleteAttributesRequest = (BatchDeleteAttributesRequest)object;
        if (batchDeleteAttributesRequest.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (batchDeleteAttributesRequest.getDomainName() != null && !batchDeleteAttributesRequest.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (batchDeleteAttributesRequest.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return batchDeleteAttributesRequest.getItems() == null || ((Object)batchDeleteAttributesRequest.getItems()).equals(this.getItems());
    }
}

