/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchPutAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private ListWithAutoConstructFlag<ReplaceableItem> items;

    public BatchPutAttributesRequest() {
    }

    public BatchPutAttributesRequest(String string, List<ReplaceableItem> list) {
        this.setDomainName(string);
        this.setItems(list);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public BatchPutAttributesRequest withDomainName(String string) {
        this.domainName = string;
        return this;
    }

    public List<ReplaceableItem> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<ReplaceableItem> collection) {
        if (collection == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.items = listWithAutoConstructFlag;
    }

    public BatchPutAttributesRequest withItems(ReplaceableItem ... replaceableItemArray) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<ReplaceableItem>(replaceableItemArray.length));
        }
        for (ReplaceableItem replaceableItem : replaceableItemArray) {
            this.getItems().add(replaceableItem);
        }
        return this;
    }

    public BatchPutAttributesRequest withItems(Collection<ReplaceableItem> collection) {
        if (collection == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.items = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getDomainName() != null) {
            stringBuilder.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItems() != null) {
            stringBuilder.append("Items: " + this.getItems());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        n = 31 * n + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BatchPutAttributesRequest)) {
            return false;
        }
        BatchPutAttributesRequest batchPutAttributesRequest = (BatchPutAttributesRequest)object;
        if (batchPutAttributesRequest.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (batchPutAttributesRequest.getDomainName() != null && !batchPutAttributesRequest.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (batchPutAttributesRequest.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        return batchPutAttributesRequest.getItems() == null || ((Object)batchPutAttributesRequest.getItems()).equals(this.getItems());
    }
}

