/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeletableItem
implements Serializable {
    private String name;
    private ListWithAutoConstructFlag<Attribute> attributes;

    public DeletableItem() {
    }

    public DeletableItem(String string, List<Attribute> list) {
        this.setName(string);
        this.setAttributes(list);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public DeletableItem withName(String string) {
        this.name = string;
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> collection) {
        if (collection == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributes = listWithAutoConstructFlag;
    }

    public DeletableItem withAttributes(Attribute ... attributeArray) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<Attribute>(attributeArray.length));
        }
        for (Attribute attribute : attributeArray) {
            this.getAttributes().add(attribute);
        }
        return this;
    }

    public DeletableItem withAttributes(Collection<Attribute> collection) {
        if (collection == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributes = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getName() != null) {
            stringBuilder.append("Name: " + this.getName() + ",");
        }
        if (this.getAttributes() != null) {
            stringBuilder.append("Attributes: " + this.getAttributes());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        n = 31 * n + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DeletableItem)) {
            return false;
        }
        DeletableItem deletableItem = (DeletableItem)object;
        if (deletableItem.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (deletableItem.getName() != null && !deletableItem.getName().equals(this.getName())) {
            return false;
        }
        if (deletableItem.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return deletableItem.getAttributes() == null || ((Object)deletableItem.getAttributes()).equals(this.getAttributes());
    }
}

