/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteAttributesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String domainName;
    private String itemName;
    private ListWithAutoConstructFlag<Attribute> attributes;
    private UpdateCondition expected;

    public DeleteAttributesRequest() {
    }

    public DeleteAttributesRequest(String string, String string2) {
        this.setDomainName(string);
        this.setItemName(string2);
    }

    public DeleteAttributesRequest(String string, String string2, List<Attribute> list) {
        this.setDomainName(string);
        this.setItemName(string2);
        this.setAttributes(list);
    }

    public DeleteAttributesRequest(String string, String string2, List<Attribute> list, UpdateCondition updateCondition) {
        this.setDomainName(string);
        this.setItemName(string2);
        this.setAttributes(list);
        this.setExpected(updateCondition);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String string) {
        this.domainName = string;
    }

    public DeleteAttributesRequest withDomainName(String string) {
        this.domainName = string;
        return this;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    public DeleteAttributesRequest withItemName(String string) {
        this.itemName = string;
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> collection) {
        if (collection == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributes = listWithAutoConstructFlag;
    }

    public DeleteAttributesRequest withAttributes(Attribute ... attributeArray) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<Attribute>(attributeArray.length));
        }
        for (Attribute attribute : attributeArray) {
            this.getAttributes().add(attribute);
        }
        return this;
    }

    public DeleteAttributesRequest withAttributes(Collection<Attribute> collection) {
        if (collection == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributes = listWithAutoConstructFlag;
        }
        return this;
    }

    public UpdateCondition getExpected() {
        return this.expected;
    }

    public void setExpected(UpdateCondition updateCondition) {
        this.expected = updateCondition;
    }

    public DeleteAttributesRequest withExpected(UpdateCondition updateCondition) {
        this.expected = updateCondition;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getDomainName() != null) {
            stringBuilder.append("DomainName: " + this.getDomainName() + ",");
        }
        if (this.getItemName() != null) {
            stringBuilder.append("ItemName: " + this.getItemName() + ",");
        }
        if (this.getAttributes() != null) {
            stringBuilder.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getExpected() != null) {
            stringBuilder.append("Expected: " + this.getExpected());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        n = 31 * n + (this.getItemName() == null ? 0 : this.getItemName().hashCode());
        n = 31 * n + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        n = 31 * n + (this.getExpected() == null ? 0 : this.getExpected().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DeleteAttributesRequest)) {
            return false;
        }
        DeleteAttributesRequest deleteAttributesRequest = (DeleteAttributesRequest)object;
        if (deleteAttributesRequest.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (deleteAttributesRequest.getDomainName() != null && !deleteAttributesRequest.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (deleteAttributesRequest.getItemName() == null ^ this.getItemName() == null) {
            return false;
        }
        if (deleteAttributesRequest.getItemName() != null && !deleteAttributesRequest.getItemName().equals(this.getItemName())) {
            return false;
        }
        if (deleteAttributesRequest.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (deleteAttributesRequest.getAttributes() != null && !((Object)deleteAttributesRequest.getAttributes()).equals(this.getAttributes())) {
            return false;
        }
        if (deleteAttributesRequest.getExpected() == null ^ this.getExpected() == null) {
            return false;
        }
        return deleteAttributesRequest.getExpected() == null || deleteAttributesRequest.getExpected().equals(this.getExpected());
    }
}

