/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.Attribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Item
implements Serializable {
    private String name;
    private String alternateNameEncoding;
    private ListWithAutoConstructFlag<Attribute> attributes;

    public Item() {
    }

    public Item(String string, List<Attribute> list) {
        this.setName(string);
        this.setAttributes(list);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Item withName(String string) {
        this.name = string;
        return this;
    }

    public String getAlternateNameEncoding() {
        return this.alternateNameEncoding;
    }

    public void setAlternateNameEncoding(String string) {
        this.alternateNameEncoding = string;
    }

    public Item withAlternateNameEncoding(String string) {
        this.alternateNameEncoding = string;
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> collection) {
        if (collection == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributes = listWithAutoConstructFlag;
    }

    public Item withAttributes(Attribute ... attributeArray) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<Attribute>(attributeArray.length));
        }
        for (Attribute attribute : attributeArray) {
            this.getAttributes().add(attribute);
        }
        return this;
    }

    public Item withAttributes(Collection<Attribute> collection) {
        if (collection == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributes = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getName() != null) {
            stringBuilder.append("Name: " + this.getName() + ",");
        }
        if (this.getAlternateNameEncoding() != null) {
            stringBuilder.append("AlternateNameEncoding: " + this.getAlternateNameEncoding() + ",");
        }
        if (this.getAttributes() != null) {
            stringBuilder.append("Attributes: " + this.getAttributes());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        n = 31 * n + (this.getAlternateNameEncoding() == null ? 0 : this.getAlternateNameEncoding().hashCode());
        n = 31 * n + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Item)) {
            return false;
        }
        Item item = (Item)object;
        if (item.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (item.getName() != null && !item.getName().equals(this.getName())) {
            return false;
        }
        if (item.getAlternateNameEncoding() == null ^ this.getAlternateNameEncoding() == null) {
            return false;
        }
        if (item.getAlternateNameEncoding() != null && !item.getAlternateNameEncoding().equals(this.getAlternateNameEncoding())) {
            return false;
        }
        if (item.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return item.getAttributes() == null || ((Object)item.getAttributes()).equals(this.getAttributes());
    }
}

