/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplaceableItem
implements Serializable {
    private String name;
    private ListWithAutoConstructFlag<ReplaceableAttribute> attributes;

    public ReplaceableItem() {
    }

    public ReplaceableItem(String string) {
        this.setName(string);
    }

    public ReplaceableItem(String string, List<ReplaceableAttribute> list) {
        this.setName(string);
        this.setAttributes(list);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ReplaceableItem withName(String string) {
        this.name = string;
        return this;
    }

    public List<ReplaceableAttribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new ListWithAutoConstructFlag();
            this.attributes.setAutoConstruct(true);
        }
        return this.attributes;
    }

    public void setAttributes(Collection<ReplaceableAttribute> collection) {
        if (collection == null) {
            this.attributes = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.attributes = listWithAutoConstructFlag;
    }

    public ReplaceableItem withAttributes(ReplaceableAttribute ... replaceableAttributeArray) {
        if (this.getAttributes() == null) {
            this.setAttributes(new ArrayList<ReplaceableAttribute>(replaceableAttributeArray.length));
        }
        for (ReplaceableAttribute replaceableAttribute : replaceableAttributeArray) {
            this.getAttributes().add(replaceableAttribute);
        }
        return this;
    }

    public ReplaceableItem withAttributes(Collection<ReplaceableAttribute> collection) {
        if (collection == null) {
            this.attributes = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.attributes = listWithAutoConstructFlag;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getName() != null) {
            stringBuilder.append("Name: " + this.getName() + ",");
        }
        if (this.getAttributes() != null) {
            stringBuilder.append("Attributes: " + this.getAttributes());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        n = 31 * n + (this.getAttributes() == null ? 0 : ((Object)this.getAttributes()).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ReplaceableItem)) {
            return false;
        }
        ReplaceableItem replaceableItem = (ReplaceableItem)object;
        if (replaceableItem.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (replaceableItem.getName() != null && !replaceableItem.getName().equals(this.getName())) {
            return false;
        }
        if (replaceableItem.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        return replaceableItem.getAttributes() == null || ((Object)replaceableItem.getAttributes()).equals(this.getAttributes());
    }
}

