/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simpledb.model.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SelectResult
implements Serializable {
    private ListWithAutoConstructFlag<Item> items;
    private String nextToken;

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<Item> collection) {
        if (collection == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
        listWithAutoConstructFlag.addAll(collection);
        this.items = listWithAutoConstructFlag;
    }

    public SelectResult withItems(Item ... itemArray) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<Item>(itemArray.length));
        }
        for (Item item : itemArray) {
            this.getItems().add(item);
        }
        return this;
    }

    public SelectResult withItems(Collection<Item> collection) {
        if (collection == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag listWithAutoConstructFlag = new ListWithAutoConstructFlag(collection.size());
            listWithAutoConstructFlag.addAll(collection);
            this.items = listWithAutoConstructFlag;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String string) {
        this.nextToken = string;
    }

    public SelectResult withNextToken(String string) {
        this.nextToken = string;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (this.getItems() != null) {
            stringBuilder.append("Items: " + this.getItems() + ",");
        }
        if (this.getNextToken() != null) {
            stringBuilder.append("NextToken: " + this.getNextToken());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        n = 31 * n + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SelectResult)) {
            return false;
        }
        SelectResult selectResult = (SelectResult)object;
        if (selectResult.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (selectResult.getItems() != null && !((Object)selectResult.getItems()).equals(this.getItems())) {
            return false;
        }
        if (selectResult.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return selectResult.getNextToken() == null || selectResult.getNextToken().equals(this.getNextToken());
    }
}

