/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.javax.xml.stream.events.XMLEvent;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class AttributeStaxUnmarshaller
implements Unmarshaller<Attribute, StaxUnmarshallerContext> {
    private static AttributeStaxUnmarshaller instance;

    public Attribute unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        Attribute attribute = new Attribute();
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            n2 += 2;
        }
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return attribute;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("Name", n2)) {
                    attribute.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("Name/@encoding", n2)) {
                    attribute.setAlternateNameEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("Value", n2)) {
                    attribute.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("Value/@encoding", n2)) continue;
                attribute.setAlternateValueEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return attribute;
    }

    public static AttributeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new AttributeStaxUnmarshaller();
        }
        return instance;
    }
}

