/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.BatchDeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.DeletableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class BatchDeleteAttributesRequestMarshaller
implements Marshaller<Request<BatchDeleteAttributesRequest>, BatchDeleteAttributesRequest> {
    public Request<BatchDeleteAttributesRequest> marshall(BatchDeleteAttributesRequest batchDeleteAttributesRequest) {
        if (batchDeleteAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)batchDeleteAttributesRequest, "AmazonSimpleDB");
        defaultRequest.addParameter("Action", "BatchDeleteAttributes");
        defaultRequest.addParameter("Version", "2009-04-15");
        if (batchDeleteAttributesRequest.getDomainName() != null) {
            defaultRequest.addParameter("DomainName", StringUtils.fromString((String)batchDeleteAttributesRequest.getDomainName()));
        }
        List<DeletableItem> list = batchDeleteAttributesRequest.getItems();
        int n = 1;
        for (DeletableItem deletableItem : list) {
            DeletableItem deletableItem2 = deletableItem;
            if (deletableItem2 != null) {
                if (deletableItem2.getName() != null) {
                    defaultRequest.addParameter("Item." + n + ".ItemName", StringUtils.fromString((String)deletableItem2.getName()));
                }
                List<Attribute> list2 = deletableItem2.getAttributes();
                int n2 = 1;
                for (Attribute attribute : list2) {
                    Attribute attribute2 = attribute;
                    if (attribute2 != null) {
                        if (attribute2.getName() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".Name", StringUtils.fromString((String)attribute2.getName()));
                        }
                        if (attribute2.getAlternateNameEncoding() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".AlternateNameEncoding", StringUtils.fromString((String)attribute2.getAlternateNameEncoding()));
                        }
                        if (attribute2.getValue() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".Value", StringUtils.fromString((String)attribute2.getValue()));
                        }
                        if (attribute2.getAlternateValueEncoding() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".AlternateValueEncoding", StringUtils.fromString((String)attribute2.getAlternateValueEncoding()));
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return defaultRequest;
    }
}

