/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.BatchPutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.ReplaceableItem;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class BatchPutAttributesRequestMarshaller
implements Marshaller<Request<BatchPutAttributesRequest>, BatchPutAttributesRequest> {
    public Request<BatchPutAttributesRequest> marshall(BatchPutAttributesRequest batchPutAttributesRequest) {
        if (batchPutAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)batchPutAttributesRequest, "AmazonSimpleDB");
        defaultRequest.addParameter("Action", "BatchPutAttributes");
        defaultRequest.addParameter("Version", "2009-04-15");
        if (batchPutAttributesRequest.getDomainName() != null) {
            defaultRequest.addParameter("DomainName", StringUtils.fromString((String)batchPutAttributesRequest.getDomainName()));
        }
        List<ReplaceableItem> list = batchPutAttributesRequest.getItems();
        int n = 1;
        for (ReplaceableItem replaceableItem : list) {
            ReplaceableItem replaceableItem2 = replaceableItem;
            if (replaceableItem2 != null) {
                if (replaceableItem2.getName() != null) {
                    defaultRequest.addParameter("Item." + n + ".ItemName", StringUtils.fromString((String)replaceableItem2.getName()));
                }
                List<ReplaceableAttribute> list2 = replaceableItem2.getAttributes();
                int n2 = 1;
                for (ReplaceableAttribute replaceableAttribute : list2) {
                    ReplaceableAttribute replaceableAttribute2 = replaceableAttribute;
                    if (replaceableAttribute2 != null) {
                        if (replaceableAttribute2.getName() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".Name", StringUtils.fromString((String)replaceableAttribute2.getName()));
                        }
                        if (replaceableAttribute2.getValue() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".Value", StringUtils.fromString((String)replaceableAttribute2.getValue()));
                        }
                        if (replaceableAttribute2.isReplace() != null) {
                            defaultRequest.addParameter("Item." + n + ".Attribute." + n2 + ".Replace", StringUtils.fromBoolean((Boolean)replaceableAttribute2.isReplace()));
                        }
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return defaultRequest;
    }
}

