/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.Attribute;
import com.amazonaws.services.simpledb.model.DeleteAttributesRequest;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DeleteAttributesRequestMarshaller
implements Marshaller<Request<DeleteAttributesRequest>, DeleteAttributesRequest> {
    public Request<DeleteAttributesRequest> marshall(DeleteAttributesRequest deleteAttributesRequest) {
        if (deleteAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)deleteAttributesRequest, "AmazonSimpleDB");
        defaultRequest.addParameter("Action", "DeleteAttributes");
        defaultRequest.addParameter("Version", "2009-04-15");
        if (deleteAttributesRequest.getDomainName() != null) {
            defaultRequest.addParameter("DomainName", StringUtils.fromString((String)deleteAttributesRequest.getDomainName()));
        }
        if (deleteAttributesRequest.getItemName() != null) {
            defaultRequest.addParameter("ItemName", StringUtils.fromString((String)deleteAttributesRequest.getItemName()));
        }
        List<Attribute> list = deleteAttributesRequest.getAttributes();
        int n = 1;
        for (Attribute attribute : list) {
            Attribute attribute2 = attribute;
            if (attribute2 != null) {
                if (attribute2.getName() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".Name", StringUtils.fromString((String)attribute2.getName()));
                }
                if (attribute2.getAlternateNameEncoding() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".AlternateNameEncoding", StringUtils.fromString((String)attribute2.getAlternateNameEncoding()));
                }
                if (attribute2.getValue() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".Value", StringUtils.fromString((String)attribute2.getValue()));
                }
                if (attribute2.getAlternateValueEncoding() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".AlternateValueEncoding", StringUtils.fromString((String)attribute2.getAlternateValueEncoding()));
                }
            }
            ++n;
        }
        UpdateCondition updateCondition = deleteAttributesRequest.getExpected();
        if (updateCondition != null) {
            if (updateCondition.getName() != null) {
                defaultRequest.addParameter("Expected.Name", StringUtils.fromString((String)updateCondition.getName()));
            }
            if (updateCondition.getValue() != null) {
                defaultRequest.addParameter("Expected.Value", StringUtils.fromString((String)updateCondition.getValue()));
            }
            if (updateCondition.isExists() != null) {
                defaultRequest.addParameter("Expected.Exists", StringUtils.fromBoolean((Boolean)updateCondition.isExists()));
            }
        }
        return defaultRequest;
    }
}

