/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.javax.xml.stream.events.XMLEvent;
import com.amazonaws.services.simpledb.model.DomainMetadataResult;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class DomainMetadataResultStaxUnmarshaller
implements Unmarshaller<DomainMetadataResult, StaxUnmarshallerContext> {
    private static DomainMetadataResultStaxUnmarshaller instance;

    public DomainMetadataResult unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        DomainMetadataResult domainMetadataResult = new DomainMetadataResult();
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            n2 += 2;
        }
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return domainMetadataResult;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("ItemCount", n2)) {
                    domainMetadataResult.setItemCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("ItemNamesSizeBytes", n2)) {
                    domainMetadataResult.setItemNamesSizeBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("AttributeNameCount", n2)) {
                    domainMetadataResult.setAttributeNameCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("AttributeNamesSizeBytes", n2)) {
                    domainMetadataResult.setAttributeNamesSizeBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("AttributeValueCount", n2)) {
                    domainMetadataResult.setAttributeValueCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("AttributeValuesSizeBytes", n2)) {
                    domainMetadataResult.setAttributeValuesSizeBytes(SimpleTypeStaxUnmarshallers.LongStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("Timestamp", n2)) continue;
                domainMetadataResult.setTimestamp(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return domainMetadataResult;
    }

    public static DomainMetadataResultStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DomainMetadataResultStaxUnmarshaller();
        }
        return instance;
    }
}

