/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.GetAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class GetAttributesRequestMarshaller
implements Marshaller<Request<GetAttributesRequest>, GetAttributesRequest> {
    public Request<GetAttributesRequest> marshall(GetAttributesRequest getAttributesRequest) {
        if (getAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)getAttributesRequest, "AmazonSimpleDB");
        defaultRequest.addParameter("Action", "GetAttributes");
        defaultRequest.addParameter("Version", "2009-04-15");
        if (getAttributesRequest.getDomainName() != null) {
            defaultRequest.addParameter("DomainName", StringUtils.fromString((String)getAttributesRequest.getDomainName()));
        }
        if (getAttributesRequest.getItemName() != null) {
            defaultRequest.addParameter("ItemName", StringUtils.fromString((String)getAttributesRequest.getItemName()));
        }
        List<String> list = getAttributesRequest.getAttributeNames();
        int n = 1;
        for (String string : list) {
            if (string != null) {
                defaultRequest.addParameter("AttributeName." + n, StringUtils.fromString((String)string));
            }
            ++n;
        }
        if (getAttributesRequest.isConsistentRead() != null) {
            defaultRequest.addParameter("ConsistentRead", StringUtils.fromBoolean((Boolean)getAttributesRequest.isConsistentRead()));
        }
        return defaultRequest;
    }
}

