/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.javax.xml.stream.events.XMLEvent;
import com.amazonaws.services.simpledb.model.Item;
import com.amazonaws.services.simpledb.model.transform.AttributeStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

public class ItemStaxUnmarshaller
implements Unmarshaller<Item, StaxUnmarshallerContext> {
    private static ItemStaxUnmarshaller instance;

    public Item unmarshall(StaxUnmarshallerContext staxUnmarshallerContext) throws Exception {
        Item item = new Item();
        int n = staxUnmarshallerContext.getCurrentDepth();
        int n2 = n + 1;
        if (staxUnmarshallerContext.isStartOfDocument()) {
            n2 += 2;
        }
        while (true) {
            XMLEvent xMLEvent;
            if ((xMLEvent = staxUnmarshallerContext.nextEvent()).isEndDocument()) {
                return item;
            }
            if (xMLEvent.isAttribute() || xMLEvent.isStartElement()) {
                if (staxUnmarshallerContext.testExpression("Name", n2)) {
                    item.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (staxUnmarshallerContext.testExpression("Name/@encoding", n2)) {
                    item.setAlternateNameEncoding(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                    continue;
                }
                if (!staxUnmarshallerContext.testExpression("Attribute", n2)) continue;
                item.getAttributes().add(AttributeStaxUnmarshaller.getInstance().unmarshall(staxUnmarshallerContext));
                continue;
            }
            if (xMLEvent.isEndElement() && staxUnmarshallerContext.getCurrentDepth() < n) break;
        }
        return item;
    }

    public static ItemStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new ItemStaxUnmarshaller();
        }
        return instance;
    }
}

