/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class PutAttributesRequestMarshaller
implements Marshaller<Request<PutAttributesRequest>, PutAttributesRequest> {
    public Request<PutAttributesRequest> marshall(PutAttributesRequest putAttributesRequest) {
        if (putAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest defaultRequest = new DefaultRequest((AmazonWebServiceRequest)putAttributesRequest, "AmazonSimpleDB");
        defaultRequest.addParameter("Action", "PutAttributes");
        defaultRequest.addParameter("Version", "2009-04-15");
        if (putAttributesRequest.getDomainName() != null) {
            defaultRequest.addParameter("DomainName", StringUtils.fromString((String)putAttributesRequest.getDomainName()));
        }
        if (putAttributesRequest.getItemName() != null) {
            defaultRequest.addParameter("ItemName", StringUtils.fromString((String)putAttributesRequest.getItemName()));
        }
        List<ReplaceableAttribute> list = putAttributesRequest.getAttributes();
        int n = 1;
        for (ReplaceableAttribute replaceableAttribute : list) {
            ReplaceableAttribute replaceableAttribute2 = replaceableAttribute;
            if (replaceableAttribute2 != null) {
                if (replaceableAttribute2.getName() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".Name", StringUtils.fromString((String)replaceableAttribute2.getName()));
                }
                if (replaceableAttribute2.getValue() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".Value", StringUtils.fromString((String)replaceableAttribute2.getValue()));
                }
                if (replaceableAttribute2.isReplace() != null) {
                    defaultRequest.addParameter("Attribute." + n + ".Replace", StringUtils.fromBoolean((Boolean)replaceableAttribute2.isReplace()));
                }
            }
            ++n;
        }
        UpdateCondition updateCondition = putAttributesRequest.getExpected();
        if (updateCondition != null) {
            if (updateCondition.getName() != null) {
                defaultRequest.addParameter("Expected.Name", StringUtils.fromString((String)updateCondition.getName()));
            }
            if (updateCondition.getValue() != null) {
                defaultRequest.addParameter("Expected.Value", StringUtils.fromString((String)updateCondition.getValue()));
            }
            if (updateCondition.isExists() != null) {
                defaultRequest.addParameter("Expected.Exists", StringUtils.fromBoolean((Boolean)updateCondition.isExists()));
            }
        }
        return defaultRequest;
    }
}

