/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

public class SimpleDBUtils {
    private static String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    public static String encodeZeroPadding(int n, int n2) {
        String string = Integer.toString(n);
        int n3 = n2 - string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 + string.length());
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String encodeZeroPadding(long l, int n) {
        String string = Long.toString(l);
        int n2 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + string.length());
        for (int i = 0; i < n2; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String encodeZeroPadding(float f, int n) {
        String string = Float.toString(f);
        int n2 = string.indexOf(46);
        n2 = n2 >= 0 ? n2 : string.length();
        int n3 = n - n2;
        StringBuffer stringBuffer = new StringBuffer(n3 + string.length());
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int decodeZeroPaddingInt(String string) {
        return Integer.parseInt(string, 10);
    }

    public static long decodeZeroPaddingLong(String string) {
        return Long.parseLong(string, 10);
    }

    public static float decodeZeroPaddingFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public static String encodeRealNumberRange(int n, int n2, int n3) {
        long l = n + n3;
        String string = Long.toString(l);
        int n4 = n2 - string.length();
        StringBuffer stringBuffer = new StringBuffer(n4 + string.length());
        for (int i = 0; i < n4; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String encodeRealNumberRange(long l, int n, long l2) {
        long l3 = l + l2;
        String string = Long.toString(l3);
        int n2 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + string.length());
        for (int i = 0; i < n2; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String encodeRealNumberRange(float f, int n, int n2, int n3) {
        long l;
        int n4 = (int)Math.pow(10.0, n2);
        long l2 = Math.round((double)f * (double)n4);
        long l3 = l2 + (l = (long)(n3 * n4));
        if (l3 < 0L) {
            throw new IllegalArgumentException("OffsetNumber[" + l3 + "] is negative - Number[" + f + "], maxDigitsLeft[" + n + "], maxDigitsRight[" + n2 + "], offsetValue[" + n3 + "]");
        }
        String string = Long.toString(l3);
        int n5 = string.length();
        int n6 = n + n2 - n5;
        if (n6 < 0) {
            throw new IllegalArgumentException("Number[" + f + "] has too many digits - maxDigitsLeft[" + n + "], maxDigitsRight[" + n2 + "], offsetValue[" + n3 + "]");
        }
        StringBuffer stringBuffer = new StringBuffer(n6 + string.length());
        for (int i = 0; i < n6; ++i) {
            stringBuffer.insert(i, '0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static int decodeRealNumberRangeInt(String string, int n) {
        long l = Long.parseLong(string, 10);
        return (int)(l - (long)n);
    }

    public static long decodeRealNumberRangeLong(String string, long l) {
        long l2 = Long.parseLong(string, 10);
        return l2 - l;
    }

    public static float decodeRealNumberRangeFloat(String string, int n, int n2) {
        long l = Long.parseLong(string, 10);
        int n3 = (int)Math.pow(10.0, n);
        double d = l - (long)(n2 * n3);
        return (float)(d / (double)n3);
    }

    public static String encodeDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        String string = simpleDateFormat.format(date);
        return string.substring(0, string.length() - 2) + ":" + string.substring(string.length() - 2);
    }

    public static Date decodeDate(String string) throws ParseException {
        String string2 = string.substring(0, string.length() - 3) + string.substring(string.length() - 2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        return simpleDateFormat.parse(string2);
    }

    public static String quoteValues(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : collection) {
            if (!bl) {
                stringBuilder.append(",");
            }
            bl = false;
            stringBuilder.append(SimpleDBUtils.quoteValue(string));
        }
        return stringBuilder.toString();
    }

    public static String quoteValue(String string) {
        return "'" + SimpleDBUtils.replaceChar(string, "'", "''") + "'";
    }

    public static String quoteName(String string) {
        return "`" + SimpleDBUtils.replaceChar(string, "`", "``") + "`";
    }

    protected static String replaceChar(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < stringBuilder.length() && (i = stringBuilder.indexOf(string2, i)) != -1; i += string3.length()) {
            stringBuilder.replace(i, i + string2.length(), string3);
        }
        return stringBuilder.toString();
    }
}

