/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.http.UrlHttpClient;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.model.AddPermissionRequest;
import com.amazonaws.services.sns.model.CheckIfPhoneNumberIsOptedOutRequest;
import com.amazonaws.services.sns.model.CheckIfPhoneNumberIsOptedOutResult;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.services.sns.model.ConfirmSubscriptionResult;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.services.sns.model.CreatePlatformApplicationResult;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.services.sns.model.CreatePlatformEndpointResult;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.CreateTopicResult;
import com.amazonaws.services.sns.model.DeleteEndpointRequest;
import com.amazonaws.services.sns.model.DeletePlatformApplicationRequest;
import com.amazonaws.services.sns.model.DeleteTopicRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.GetEndpointAttributesResult;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.GetPlatformApplicationAttributesResult;
import com.amazonaws.services.sns.model.GetSMSAttributesRequest;
import com.amazonaws.services.sns.model.GetSMSAttributesResult;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.GetSubscriptionAttributesResult;
import com.amazonaws.services.sns.model.GetTopicAttributesRequest;
import com.amazonaws.services.sns.model.GetTopicAttributesResult;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationRequest;
import com.amazonaws.services.sns.model.ListEndpointsByPlatformApplicationResult;
import com.amazonaws.services.sns.model.ListPhoneNumbersOptedOutRequest;
import com.amazonaws.services.sns.model.ListPhoneNumbersOptedOutResult;
import com.amazonaws.services.sns.model.ListPlatformApplicationsRequest;
import com.amazonaws.services.sns.model.ListPlatformApplicationsResult;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsRequest;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTopicsRequest;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.OptInPhoneNumberRequest;
import com.amazonaws.services.sns.model.OptInPhoneNumberResult;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.PublishResult;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.services.sns.model.SetSMSAttributesRequest;
import com.amazonaws.services.sns.model.SetSMSAttributesResult;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.services.sns.model.SubscribeResult;
import com.amazonaws.services.sns.model.UnsubscribeRequest;
import com.amazonaws.services.sns.model.transform.AddPermissionRequestMarshaller;
import com.amazonaws.services.sns.model.transform.AuthorizationErrorExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.CheckIfPhoneNumberIsOptedOutRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CheckIfPhoneNumberIsOptedOutResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ConfirmSubscriptionRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ConfirmSubscriptionResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformApplicationRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformApplicationResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformEndpointRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CreatePlatformEndpointResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.CreateTopicRequestMarshaller;
import com.amazonaws.services.sns.model.transform.CreateTopicResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.DeleteEndpointRequestMarshaller;
import com.amazonaws.services.sns.model.transform.DeletePlatformApplicationRequestMarshaller;
import com.amazonaws.services.sns.model.transform.DeleteTopicRequestMarshaller;
import com.amazonaws.services.sns.model.transform.EndpointDisabledExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetEndpointAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetEndpointAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetPlatformApplicationAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetPlatformApplicationAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetSMSAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetSMSAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetSubscriptionAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetSubscriptionAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.GetTopicAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.GetTopicAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.InternalErrorExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListEndpointsByPlatformApplicationRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListEndpointsByPlatformApplicationResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListPhoneNumbersOptedOutRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListPhoneNumbersOptedOutResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListPlatformApplicationsRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListPlatformApplicationsResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsByTopicRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsByTopicResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListSubscriptionsResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.ListTopicsRequestMarshaller;
import com.amazonaws.services.sns.model.transform.ListTopicsResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.OptInPhoneNumberRequestMarshaller;
import com.amazonaws.services.sns.model.transform.OptInPhoneNumberResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.PlatformApplicationDisabledExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.PublishRequestMarshaller;
import com.amazonaws.services.sns.model.transform.PublishResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.RemovePermissionRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetEndpointAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetPlatformApplicationAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetSMSAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetSMSAttributesResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.SetSubscriptionAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SetTopicAttributesRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SubscribeRequestMarshaller;
import com.amazonaws.services.sns.model.transform.SubscribeResultStaxUnmarshaller;
import com.amazonaws.services.sns.model.transform.SubscriptionLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.ThrottledExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.TopicLimitExceededExceptionUnmarshaller;
import com.amazonaws.services.sns.model.transform.UnsubscribeRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class AmazonSNSClient
extends AmazonWebServiceClient
implements AmazonSNS {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    @Deprecated
    public AmazonSNSClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    @Deprecated
    public AmazonSNSClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonSNSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSNSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(awsCredentials), clientConfiguration);
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, (HttpClient)new UrlHttpClient(clientConfiguration));
    }

    @Deprecated
    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonSNSClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    public AmazonSNSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, HttpClient httpClient) {
        super(AmazonSNSClient.adjustClientConfiguration(clientConfiguration), httpClient);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new AuthorizationErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new EndpointDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InternalErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new NotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new PlatformApplicationDisabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new SubscriptionLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new ThrottledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new TopicLimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add((Unmarshaller<AmazonServiceException, Node>)new StandardErrorUnmarshaller());
        this.setEndpoint("sns.us-east-1.amazonaws.com");
        this.endpointPrefix = "sns";
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/sns/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/sns/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPermission(AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(addPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddPermissionRequest> request = null;
        Response response = null;
        try {
            request = new AddPermissionRequestMarshaller().marshall(addPermissionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckIfPhoneNumberIsOptedOutResult checkIfPhoneNumberIsOptedOut(CheckIfPhoneNumberIsOptedOutRequest checkIfPhoneNumberIsOptedOutRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(checkIfPhoneNumberIsOptedOutRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CheckIfPhoneNumberIsOptedOutRequest> request = null;
        Response<CheckIfPhoneNumberIsOptedOutResult> response = null;
        try {
            request = new CheckIfPhoneNumberIsOptedOutRequestMarshaller().marshall(checkIfPhoneNumberIsOptedOutRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CheckIfPhoneNumberIsOptedOutResultStaxUnmarshaller(), executionContext);
            CheckIfPhoneNumberIsOptedOutResult checkIfPhoneNumberIsOptedOutResult = (CheckIfPhoneNumberIsOptedOutResult)response.getAwsResponse();
            return checkIfPhoneNumberIsOptedOutResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfirmSubscriptionResult confirmSubscription(ConfirmSubscriptionRequest confirmSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(confirmSubscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ConfirmSubscriptionRequest> request = null;
        Response<ConfirmSubscriptionResult> response = null;
        try {
            request = new ConfirmSubscriptionRequestMarshaller().marshall(confirmSubscriptionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ConfirmSubscriptionResultStaxUnmarshaller(), executionContext);
            ConfirmSubscriptionResult confirmSubscriptionResult = (ConfirmSubscriptionResult)response.getAwsResponse();
            return confirmSubscriptionResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlatformApplicationResult createPlatformApplication(CreatePlatformApplicationRequest createPlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createPlatformApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlatformApplicationRequest> request = null;
        Response<CreatePlatformApplicationResult> response = null;
        try {
            request = new CreatePlatformApplicationRequestMarshaller().marshall(createPlatformApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreatePlatformApplicationResultStaxUnmarshaller(), executionContext);
            CreatePlatformApplicationResult createPlatformApplicationResult = (CreatePlatformApplicationResult)response.getAwsResponse();
            return createPlatformApplicationResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePlatformEndpointResult createPlatformEndpoint(CreatePlatformEndpointRequest createPlatformEndpointRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createPlatformEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePlatformEndpointRequest> request = null;
        Response<CreatePlatformEndpointResult> response = null;
        try {
            request = new CreatePlatformEndpointRequestMarshaller().marshall(createPlatformEndpointRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreatePlatformEndpointResultStaxUnmarshaller(), executionContext);
            CreatePlatformEndpointResult createPlatformEndpointResult = (CreatePlatformEndpointResult)response.getAwsResponse();
            return createPlatformEndpointResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTopicResult createTopic(CreateTopicRequest createTopicRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTopicRequest> request = null;
        Response<CreateTopicResult> response = null;
        try {
            request = new CreateTopicRequestMarshaller().marshall(createTopicRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateTopicResultStaxUnmarshaller(), executionContext);
            CreateTopicResult createTopicResult = (CreateTopicResult)response.getAwsResponse();
            return createTopicResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEndpoint(DeleteEndpointRequest deleteEndpointRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteEndpointRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEndpointRequest> request = null;
        Response response = null;
        try {
            request = new DeleteEndpointRequestMarshaller().marshall(deleteEndpointRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePlatformApplication(DeletePlatformApplicationRequest deletePlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deletePlatformApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePlatformApplicationRequest> request = null;
        Response response = null;
        try {
            request = new DeletePlatformApplicationRequestMarshaller().marshall(deletePlatformApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTopic(DeleteTopicRequest deleteTopicRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTopicRequest> request = null;
        Response response = null;
        try {
            request = new DeleteTopicRequestMarshaller().marshall(deleteTopicRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEndpointAttributesResult getEndpointAttributes(GetEndpointAttributesRequest getEndpointAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getEndpointAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetEndpointAttributesRequest> request = null;
        Response<GetEndpointAttributesResult> response = null;
        try {
            request = new GetEndpointAttributesRequestMarshaller().marshall(getEndpointAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetEndpointAttributesResultStaxUnmarshaller(), executionContext);
            GetEndpointAttributesResult getEndpointAttributesResult = (GetEndpointAttributesResult)response.getAwsResponse();
            return getEndpointAttributesResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPlatformApplicationAttributesResult getPlatformApplicationAttributes(GetPlatformApplicationAttributesRequest getPlatformApplicationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getPlatformApplicationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPlatformApplicationAttributesRequest> request = null;
        Response<GetPlatformApplicationAttributesResult> response = null;
        try {
            request = new GetPlatformApplicationAttributesRequestMarshaller().marshall(getPlatformApplicationAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetPlatformApplicationAttributesResultStaxUnmarshaller(), executionContext);
            GetPlatformApplicationAttributesResult getPlatformApplicationAttributesResult = (GetPlatformApplicationAttributesResult)response.getAwsResponse();
            return getPlatformApplicationAttributesResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSMSAttributesResult getSMSAttributes(GetSMSAttributesRequest getSMSAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getSMSAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSMSAttributesRequest> request = null;
        Response<GetSMSAttributesResult> response = null;
        try {
            request = new GetSMSAttributesRequestMarshaller().marshall(getSMSAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetSMSAttributesResultStaxUnmarshaller(), executionContext);
            GetSMSAttributesResult getSMSAttributesResult = (GetSMSAttributesResult)response.getAwsResponse();
            return getSMSAttributesResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSubscriptionAttributesResult getSubscriptionAttributes(GetSubscriptionAttributesRequest getSubscriptionAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getSubscriptionAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetSubscriptionAttributesRequest> request = null;
        Response<GetSubscriptionAttributesResult> response = null;
        try {
            request = new GetSubscriptionAttributesRequestMarshaller().marshall(getSubscriptionAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetSubscriptionAttributesResultStaxUnmarshaller(), executionContext);
            GetSubscriptionAttributesResult getSubscriptionAttributesResult = (GetSubscriptionAttributesResult)response.getAwsResponse();
            return getSubscriptionAttributesResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTopicAttributesResult getTopicAttributes(GetTopicAttributesRequest getTopicAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getTopicAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTopicAttributesRequest> request = null;
        Response<GetTopicAttributesResult> response = null;
        try {
            request = new GetTopicAttributesRequestMarshaller().marshall(getTopicAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetTopicAttributesResultStaxUnmarshaller(), executionContext);
            GetTopicAttributesResult getTopicAttributesResult = (GetTopicAttributesResult)response.getAwsResponse();
            return getTopicAttributesResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEndpointsByPlatformApplicationResult listEndpointsByPlatformApplication(ListEndpointsByPlatformApplicationRequest listEndpointsByPlatformApplicationRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listEndpointsByPlatformApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEndpointsByPlatformApplicationRequest> request = null;
        Response<ListEndpointsByPlatformApplicationResult> response = null;
        try {
            request = new ListEndpointsByPlatformApplicationRequestMarshaller().marshall(listEndpointsByPlatformApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListEndpointsByPlatformApplicationResultStaxUnmarshaller(), executionContext);
            ListEndpointsByPlatformApplicationResult listEndpointsByPlatformApplicationResult = (ListEndpointsByPlatformApplicationResult)response.getAwsResponse();
            return listEndpointsByPlatformApplicationResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPhoneNumbersOptedOutResult listPhoneNumbersOptedOut(ListPhoneNumbersOptedOutRequest listPhoneNumbersOptedOutRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listPhoneNumbersOptedOutRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPhoneNumbersOptedOutRequest> request = null;
        Response<ListPhoneNumbersOptedOutResult> response = null;
        try {
            request = new ListPhoneNumbersOptedOutRequestMarshaller().marshall(listPhoneNumbersOptedOutRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListPhoneNumbersOptedOutResultStaxUnmarshaller(), executionContext);
            ListPhoneNumbersOptedOutResult listPhoneNumbersOptedOutResult = (ListPhoneNumbersOptedOutResult)response.getAwsResponse();
            return listPhoneNumbersOptedOutResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPlatformApplicationsResult listPlatformApplications(ListPlatformApplicationsRequest listPlatformApplicationsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listPlatformApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPlatformApplicationsRequest> request = null;
        Response<ListPlatformApplicationsResult> response = null;
        try {
            request = new ListPlatformApplicationsRequestMarshaller().marshall(listPlatformApplicationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListPlatformApplicationsResultStaxUnmarshaller(), executionContext);
            ListPlatformApplicationsResult listPlatformApplicationsResult = (ListPlatformApplicationsResult)response.getAwsResponse();
            return listPlatformApplicationsResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscriptionsResult listSubscriptions(ListSubscriptionsRequest listSubscriptionsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listSubscriptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSubscriptionsRequest> request = null;
        Response<ListSubscriptionsResult> response = null;
        try {
            request = new ListSubscriptionsRequestMarshaller().marshall(listSubscriptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListSubscriptionsResultStaxUnmarshaller(), executionContext);
            ListSubscriptionsResult listSubscriptionsResult = (ListSubscriptionsResult)response.getAwsResponse();
            return listSubscriptionsResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listSubscriptionsByTopicRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSubscriptionsByTopicRequest> request = null;
        Response<ListSubscriptionsByTopicResult> response = null;
        try {
            request = new ListSubscriptionsByTopicRequestMarshaller().marshall(listSubscriptionsByTopicRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListSubscriptionsByTopicResultStaxUnmarshaller(), executionContext);
            ListSubscriptionsByTopicResult listSubscriptionsByTopicResult = (ListSubscriptionsByTopicResult)response.getAwsResponse();
            return listSubscriptionsByTopicResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTopicsResult listTopics(ListTopicsRequest listTopicsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listTopicsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTopicsRequest> request = null;
        Response<ListTopicsResult> response = null;
        try {
            request = new ListTopicsRequestMarshaller().marshall(listTopicsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListTopicsResultStaxUnmarshaller(), executionContext);
            ListTopicsResult listTopicsResult = (ListTopicsResult)response.getAwsResponse();
            return listTopicsResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OptInPhoneNumberResult optInPhoneNumber(OptInPhoneNumberRequest optInPhoneNumberRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(optInPhoneNumberRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<OptInPhoneNumberRequest> request = null;
        Response<OptInPhoneNumberResult> response = null;
        try {
            request = new OptInPhoneNumberRequestMarshaller().marshall(optInPhoneNumberRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new OptInPhoneNumberResultStaxUnmarshaller(), executionContext);
            OptInPhoneNumberResult optInPhoneNumberResult = (OptInPhoneNumberResult)response.getAwsResponse();
            return optInPhoneNumberResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PublishResult publish(PublishRequest publishRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(publishRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PublishRequest> request = null;
        Response<PublishResult> response = null;
        try {
            request = new PublishRequestMarshaller().marshall(publishRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new PublishResultStaxUnmarshaller(), executionContext);
            PublishResult publishResult = (PublishResult)response.getAwsResponse();
            return publishResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        Response response = null;
        try {
            request = new RemovePermissionRequestMarshaller().marshall(removePermissionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpointAttributes(SetEndpointAttributesRequest setEndpointAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setEndpointAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetEndpointAttributesRequest> request = null;
        Response response = null;
        try {
            request = new SetEndpointAttributesRequestMarshaller().marshall(setEndpointAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlatformApplicationAttributes(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setPlatformApplicationAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetPlatformApplicationAttributesRequest> request = null;
        Response response = null;
        try {
            request = new SetPlatformApplicationAttributesRequestMarshaller().marshall(setPlatformApplicationAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetSMSAttributesResult setSMSAttributes(SetSMSAttributesRequest setSMSAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setSMSAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetSMSAttributesRequest> request = null;
        Response<SetSMSAttributesResult> response = null;
        try {
            request = new SetSMSAttributesRequestMarshaller().marshall(setSMSAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SetSMSAttributesResultStaxUnmarshaller(), executionContext);
            SetSMSAttributesResult setSMSAttributesResult = (SetSMSAttributesResult)response.getAwsResponse();
            return setSMSAttributesResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubscriptionAttributes(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setSubscriptionAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetSubscriptionAttributesRequest> request = null;
        Response response = null;
        try {
            request = new SetSubscriptionAttributesRequestMarshaller().marshall(setSubscriptionAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTopicAttributes(SetTopicAttributesRequest setTopicAttributesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setTopicAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTopicAttributesRequest> request = null;
        Response response = null;
        try {
            request = new SetTopicAttributesRequestMarshaller().marshall(setTopicAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscribeResult subscribe(SubscribeRequest subscribeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(subscribeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SubscribeRequest> request = null;
        Response<SubscribeResult> response = null;
        try {
            request = new SubscribeRequestMarshaller().marshall(subscribeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new SubscribeResultStaxUnmarshaller(), executionContext);
            SubscribeResult subscribeResult = (SubscribeResult)response.getAwsResponse();
            return subscribeResult;
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(UnsubscribeRequest unsubscribeRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(unsubscribeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UnsubscribeRequest> request = null;
        Response response = null;
        try {
            request = new UnsubscribeRequestMarshaller().marshall(unsubscribeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public void setSubscriptionAttributes(String subscriptionArn, String attributeName, String attributeValue) throws AmazonServiceException, AmazonClientException {
        SetSubscriptionAttributesRequest setSubscriptionAttributesRequest = new SetSubscriptionAttributesRequest();
        setSubscriptionAttributesRequest.setSubscriptionArn(subscriptionArn);
        setSubscriptionAttributesRequest.setAttributeName(attributeName);
        setSubscriptionAttributesRequest.setAttributeValue(attributeValue);
        this.setSubscriptionAttributes(setSubscriptionAttributesRequest);
    }

    @Override
    public GetSubscriptionAttributesResult getSubscriptionAttributes(String subscriptionArn) throws AmazonServiceException, AmazonClientException {
        GetSubscriptionAttributesRequest getSubscriptionAttributesRequest = new GetSubscriptionAttributesRequest();
        getSubscriptionAttributesRequest.setSubscriptionArn(subscriptionArn);
        return this.getSubscriptionAttributes(getSubscriptionAttributesRequest);
    }

    @Override
    public SubscribeResult subscribe(String topicArn, String protocol, String endpoint) throws AmazonServiceException, AmazonClientException {
        SubscribeRequest subscribeRequest = new SubscribeRequest();
        subscribeRequest.setTopicArn(topicArn);
        subscribeRequest.setProtocol(protocol);
        subscribeRequest.setEndpoint(endpoint);
        return this.subscribe(subscribeRequest);
    }

    @Override
    public void addPermission(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames) throws AmazonServiceException, AmazonClientException {
        AddPermissionRequest addPermissionRequest = new AddPermissionRequest();
        addPermissionRequest.setTopicArn(topicArn);
        addPermissionRequest.setLabel(label);
        addPermissionRequest.setAWSAccountIds(aWSAccountIds);
        addPermissionRequest.setActionNames(actionNames);
        this.addPermission(addPermissionRequest);
    }

    @Override
    public GetTopicAttributesResult getTopicAttributes(String topicArn) throws AmazonServiceException, AmazonClientException {
        GetTopicAttributesRequest getTopicAttributesRequest = new GetTopicAttributesRequest();
        getTopicAttributesRequest.setTopicArn(topicArn);
        return this.getTopicAttributes(getTopicAttributesRequest);
    }

    @Override
    public void removePermission(String topicArn, String label) throws AmazonServiceException, AmazonClientException {
        RemovePermissionRequest removePermissionRequest = new RemovePermissionRequest();
        removePermissionRequest.setTopicArn(topicArn);
        removePermissionRequest.setLabel(label);
        this.removePermission(removePermissionRequest);
    }

    @Override
    public ListTopicsResult listTopics() throws AmazonServiceException, AmazonClientException {
        ListTopicsRequest listTopicsRequest = new ListTopicsRequest();
        return this.listTopics(listTopicsRequest);
    }

    @Override
    public ListTopicsResult listTopics(String nextToken) throws AmazonServiceException, AmazonClientException {
        ListTopicsRequest listTopicsRequest = new ListTopicsRequest();
        listTopicsRequest.setNextToken(nextToken);
        return this.listTopics(listTopicsRequest);
    }

    @Override
    public ConfirmSubscriptionResult confirmSubscription(String topicArn, String token, String authenticateOnUnsubscribe) throws AmazonServiceException, AmazonClientException {
        ConfirmSubscriptionRequest confirmSubscriptionRequest = new ConfirmSubscriptionRequest();
        confirmSubscriptionRequest.setTopicArn(topicArn);
        confirmSubscriptionRequest.setToken(token);
        confirmSubscriptionRequest.setAuthenticateOnUnsubscribe(authenticateOnUnsubscribe);
        return this.confirmSubscription(confirmSubscriptionRequest);
    }

    @Override
    public ConfirmSubscriptionResult confirmSubscription(String topicArn, String token) throws AmazonServiceException, AmazonClientException {
        ConfirmSubscriptionRequest confirmSubscriptionRequest = new ConfirmSubscriptionRequest();
        confirmSubscriptionRequest.setTopicArn(topicArn);
        confirmSubscriptionRequest.setToken(token);
        return this.confirmSubscription(confirmSubscriptionRequest);
    }

    @Override
    public void setTopicAttributes(String topicArn, String attributeName, String attributeValue) throws AmazonServiceException, AmazonClientException {
        SetTopicAttributesRequest setTopicAttributesRequest = new SetTopicAttributesRequest();
        setTopicAttributesRequest.setTopicArn(topicArn);
        setTopicAttributesRequest.setAttributeName(attributeName);
        setTopicAttributesRequest.setAttributeValue(attributeValue);
        this.setTopicAttributes(setTopicAttributesRequest);
    }

    @Override
    public CreateTopicResult createTopic(String name) throws AmazonServiceException, AmazonClientException {
        CreateTopicRequest createTopicRequest = new CreateTopicRequest();
        createTopicRequest.setName(name);
        return this.createTopic(createTopicRequest);
    }

    @Override
    public void deleteTopic(String topicArn) throws AmazonServiceException, AmazonClientException {
        DeleteTopicRequest deleteTopicRequest = new DeleteTopicRequest();
        deleteTopicRequest.setTopicArn(topicArn);
        this.deleteTopic(deleteTopicRequest);
    }

    @Override
    public void unsubscribe(String subscriptionArn) throws AmazonServiceException, AmazonClientException {
        UnsubscribeRequest unsubscribeRequest = new UnsubscribeRequest();
        unsubscribeRequest.setSubscriptionArn(subscriptionArn);
        this.unsubscribe(unsubscribeRequest);
    }

    @Override
    public PublishResult publish(String topicArn, String message) throws AmazonServiceException, AmazonClientException {
        PublishRequest publishRequest = new PublishRequest();
        publishRequest.setTopicArn(topicArn);
        publishRequest.setMessage(message);
        return this.publish(publishRequest);
    }

    @Override
    public PublishResult publish(String topicArn, String message, String subject) throws AmazonServiceException, AmazonClientException {
        PublishRequest publishRequest = new PublishRequest();
        publishRequest.setTopicArn(topicArn);
        publishRequest.setMessage(message);
        publishRequest.setSubject(subject);
        return this.publish(publishRequest);
    }

    @Override
    public ListSubscriptionsResult listSubscriptions() throws AmazonServiceException, AmazonClientException {
        ListSubscriptionsRequest listSubscriptionsRequest = new ListSubscriptionsRequest();
        return this.listSubscriptions(listSubscriptionsRequest);
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(String nextToken) throws AmazonServiceException, AmazonClientException {
        ListSubscriptionsRequest listSubscriptionsRequest = new ListSubscriptionsRequest();
        listSubscriptionsRequest.setNextToken(nextToken);
        return this.listSubscriptions(listSubscriptionsRequest);
    }

    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(String topicArn) throws AmazonServiceException, AmazonClientException {
        ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest = new ListSubscriptionsByTopicRequest();
        listSubscriptionsByTopicRequest.setTopicArn(topicArn);
        return this.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
    }

    @Override
    public ListSubscriptionsByTopicResult listSubscriptionsByTopic(String topicArn, String nextToken) throws AmazonServiceException, AmazonClientException {
        ListSubscriptionsByTopicRequest listSubscriptionsByTopicRequest = new ListSubscriptionsByTopicRequest();
        listSubscriptionsByTopicRequest.setTopicArn(topicArn);
        listSubscriptionsByTopicRequest.setNextToken(nextToken);
        return this.listSubscriptionsByTopic(listSubscriptionsByTopicRequest);
    }

    @Override
    public ListPlatformApplicationsResult listPlatformApplications() throws AmazonServiceException, AmazonClientException {
        ListPlatformApplicationsRequest listPlatformApplicationsRequest = new ListPlatformApplicationsRequest();
        return this.listPlatformApplications(listPlatformApplicationsRequest);
    }

    @Override
    @Deprecated
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler responseHandler = new StaxResponseHandler(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, (HttpResponseHandler)responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

