/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.sns.model.Endpoint;
import com.amazonaws.util.StringUtils;
import java.util.Map;

class EndpointStaxMarshaller {
    private static EndpointStaxMarshaller instance;

    EndpointStaxMarshaller() {
    }

    public void marshall(Endpoint _endpoint, Request<?> request, String _prefix) {
        String prefix;
        if (_endpoint.getEndpointArn() != null) {
            prefix = _prefix + "EndpointArn";
            String endpointArn = _endpoint.getEndpointArn();
            request.addParameter(prefix, StringUtils.fromString((String)endpointArn));
        }
        if (_endpoint.getAttributes() != null) {
            prefix = _prefix + "Attributes";
            Map<String, String> attributes = _endpoint.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            prefix = attributesPrefix;
        }
    }

    public static EndpointStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointStaxMarshaller();
        }
        return instance;
    }
}

