/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.Endpoint;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;

class EndpointStaxUnmarshaller
implements Unmarshaller<Endpoint, StaxUnmarshallerContext> {
    private static EndpointStaxUnmarshaller instance;

    EndpointStaxUnmarshaller() {
    }

    public Endpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        Endpoint endpoint = new Endpoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("EndpointArn", targetDepth)) {
                    endpoint.setEndpointArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Attributes/entry", targetDepth)) continue;
                Map.Entry<String, String> entry = AttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                endpoint.addAttributesEntry(entry.getKey(), entry.getValue());
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return endpoint;
    }

    public static EndpointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new EndpointStaxUnmarshaller();
        }
        return instance;
    }

    private static class AttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static AttributesMapEntryUnmarshaller instance;

        private AttributesMapEntryUnmarshaller() {
        }

        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                int xmlEvent;
                if ((xmlEvent = context.nextEvent()) == 1) {
                    return entry;
                }
                if (xmlEvent == 2) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent == 3 && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AttributesMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new AttributesMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

