/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.sns.model.PlatformApplication;
import com.amazonaws.util.StringUtils;
import java.util.Map;

class PlatformApplicationStaxMarshaller {
    private static PlatformApplicationStaxMarshaller instance;

    PlatformApplicationStaxMarshaller() {
    }

    public void marshall(PlatformApplication _platformApplication, Request<?> request, String _prefix) {
        String prefix;
        if (_platformApplication.getPlatformApplicationArn() != null) {
            prefix = _prefix + "PlatformApplicationArn";
            String platformApplicationArn = _platformApplication.getPlatformApplicationArn();
            request.addParameter(prefix, StringUtils.fromString((String)platformApplicationArn));
        }
        if (_platformApplication.getAttributes() != null) {
            prefix = _prefix + "Attributes";
            Map<String, String> attributes = _platformApplication.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            prefix = attributesPrefix;
        }
    }

    public static PlatformApplicationStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new PlatformApplicationStaxMarshaller();
        }
        return instance;
    }
}

