/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.RemovePermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        String prefix;
        if (removePermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RemovePermissionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removePermissionRequest, "AmazonSNS");
        request.addParameter("Action", "RemovePermission");
        request.addParameter("Version", "2010-03-31");
        if (removePermissionRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = removePermissionRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (removePermissionRequest.getLabel() != null) {
            prefix = "Label";
            String label = removePermissionRequest.getLabel();
            request.addParameter(prefix, StringUtils.fromString((String)label));
        }
        return request;
    }
}

