/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SetSubscriptionAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetSubscriptionAttributesRequestMarshaller
implements Marshaller<Request<SetSubscriptionAttributesRequest>, SetSubscriptionAttributesRequest> {
    public Request<SetSubscriptionAttributesRequest> marshall(SetSubscriptionAttributesRequest setSubscriptionAttributesRequest) {
        String prefix;
        if (setSubscriptionAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetSubscriptionAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSubscriptionAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetSubscriptionAttributes");
        request.addParameter("Version", "2010-03-31");
        if (setSubscriptionAttributesRequest.getSubscriptionArn() != null) {
            prefix = "SubscriptionArn";
            String subscriptionArn = setSubscriptionAttributesRequest.getSubscriptionArn();
            request.addParameter(prefix, StringUtils.fromString((String)subscriptionArn));
        }
        if (setSubscriptionAttributesRequest.getAttributeName() != null) {
            prefix = "AttributeName";
            String attributeName = setSubscriptionAttributesRequest.getAttributeName();
            request.addParameter(prefix, StringUtils.fromString((String)attributeName));
        }
        if (setSubscriptionAttributesRequest.getAttributeValue() != null) {
            prefix = "AttributeValue";
            String attributeValue = setSubscriptionAttributesRequest.getAttributeValue();
            request.addParameter(prefix, StringUtils.fromString((String)attributeValue));
        }
        return request;
    }
}

