/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        String prefix;
        if (subscribeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SubscribeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)subscribeRequest, "AmazonSNS");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        if (subscribeRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = subscribeRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (subscribeRequest.getProtocol() != null) {
            prefix = "Protocol";
            String protocol = subscribeRequest.getProtocol();
            request.addParameter(prefix, StringUtils.fromString((String)protocol));
        }
        if (subscribeRequest.getEndpoint() != null) {
            prefix = "Endpoint";
            String endpoint = subscribeRequest.getEndpoint();
            request.addParameter(prefix, StringUtils.fromString((String)endpoint));
        }
        return request;
    }
}

