/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.Topic;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class TopicStaxUnmarshaller
implements Unmarshaller<Topic, StaxUnmarshallerContext> {
    private static TopicStaxUnmarshaller instance;

    TopicStaxUnmarshaller() {
    }

    public Topic unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        Topic topic = new Topic();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (!context.testExpression("TopicArn", targetDepth)) continue;
                topic.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return topic;
    }

    public static TopicStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TopicStaxUnmarshaller();
        }
        return instance;
    }
}

