/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddPermissionRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String topicArn;
    private String label;
    private List<String> aWSAccountIds = new ArrayList<String>();
    private List<String> actionNames = new ArrayList<String>();

    public AddPermissionRequest() {
    }

    public AddPermissionRequest(String topicArn, String label, List<String> aWSAccountIds, List<String> actionNames) {
        this.setTopicArn(topicArn);
        this.setLabel(label);
        this.setAWSAccountIds(aWSAccountIds);
        this.setActionNames(actionNames);
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public AddPermissionRequest withTopicArn(String topicArn) {
        this.topicArn = topicArn;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AddPermissionRequest withLabel(String label) {
        this.label = label;
        return this;
    }

    public List<String> getAWSAccountIds() {
        return this.aWSAccountIds;
    }

    public void setAWSAccountIds(Collection<String> aWSAccountIds) {
        if (aWSAccountIds == null) {
            this.aWSAccountIds = null;
            return;
        }
        this.aWSAccountIds = new ArrayList<String>(aWSAccountIds);
    }

    public AddPermissionRequest withAWSAccountIds(String ... aWSAccountIds) {
        if (this.getAWSAccountIds() == null) {
            this.aWSAccountIds = new ArrayList<String>(aWSAccountIds.length);
        }
        for (String value : aWSAccountIds) {
            this.aWSAccountIds.add(value);
        }
        return this;
    }

    public AddPermissionRequest withAWSAccountIds(Collection<String> aWSAccountIds) {
        this.setAWSAccountIds(aWSAccountIds);
        return this;
    }

    public List<String> getActionNames() {
        return this.actionNames;
    }

    public void setActionNames(Collection<String> actionNames) {
        if (actionNames == null) {
            this.actionNames = null;
            return;
        }
        this.actionNames = new ArrayList<String>(actionNames);
    }

    public AddPermissionRequest withActionNames(String ... actionNames) {
        if (this.getActionNames() == null) {
            this.actionNames = new ArrayList<String>(actionNames.length);
        }
        for (String value : actionNames) {
            this.actionNames.add(value);
        }
        return this;
    }

    public AddPermissionRequest withActionNames(Collection<String> actionNames) {
        this.setActionNames(actionNames);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: " + this.getTopicArn() + ",");
        }
        if (this.getLabel() != null) {
            sb.append("Label: " + this.getLabel() + ",");
        }
        if (this.getAWSAccountIds() != null) {
            sb.append("AWSAccountIds: " + this.getAWSAccountIds() + ",");
        }
        if (this.getActionNames() != null) {
            sb.append("ActionNames: " + this.getActionNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getLabel() == null ? 0 : this.getLabel().hashCode());
        hashCode = 31 * hashCode + (this.getAWSAccountIds() == null ? 0 : this.getAWSAccountIds().hashCode());
        hashCode = 31 * hashCode + (this.getActionNames() == null ? 0 : this.getActionNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddPermissionRequest)) {
            return false;
        }
        AddPermissionRequest other = (AddPermissionRequest)obj;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getLabel() == null ^ this.getLabel() == null) {
            return false;
        }
        if (other.getLabel() != null && !other.getLabel().equals(this.getLabel())) {
            return false;
        }
        if (other.getAWSAccountIds() == null ^ this.getAWSAccountIds() == null) {
            return false;
        }
        if (other.getAWSAccountIds() != null && !other.getAWSAccountIds().equals(this.getAWSAccountIds())) {
            return false;
        }
        if (other.getActionNames() == null ^ this.getActionNames() == null) {
            return false;
        }
        return other.getActionNames() == null || other.getActionNames().equals(this.getActionNames());
    }
}

