/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SubscribeRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String topicArn;
    private String protocol;
    private String endpoint;
    private Map<String, String> attributes = new HashMap<String, String>();
    private Boolean returnSubscriptionArn;

    public SubscribeRequest() {
    }

    public SubscribeRequest(String topicArn, String protocol, String endpoint) {
        this.setTopicArn(topicArn);
        this.setProtocol(protocol);
        this.setEndpoint(endpoint);
    }

    public String getTopicArn() {
        return this.topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }

    public SubscribeRequest withTopicArn(String topicArn) {
        this.topicArn = topicArn;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public SubscribeRequest withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public SubscribeRequest withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public SubscribeRequest withAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public SubscribeRequest addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<String, String>();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public SubscribeRequest clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public Boolean isReturnSubscriptionArn() {
        return this.returnSubscriptionArn;
    }

    public Boolean getReturnSubscriptionArn() {
        return this.returnSubscriptionArn;
    }

    public void setReturnSubscriptionArn(Boolean returnSubscriptionArn) {
        this.returnSubscriptionArn = returnSubscriptionArn;
    }

    public SubscribeRequest withReturnSubscriptionArn(Boolean returnSubscriptionArn) {
        this.returnSubscriptionArn = returnSubscriptionArn;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTopicArn() != null) {
            sb.append("TopicArn: " + this.getTopicArn() + ",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: " + this.getProtocol() + ",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: " + this.getEndpoint() + ",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: " + this.getAttributes() + ",");
        }
        if (this.getReturnSubscriptionArn() != null) {
            sb.append("ReturnSubscriptionArn: " + this.getReturnSubscriptionArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTopicArn() == null ? 0 : this.getTopicArn().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getReturnSubscriptionArn() == null ? 0 : this.getReturnSubscriptionArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribeRequest)) {
            return false;
        }
        SubscribeRequest other = (SubscribeRequest)obj;
        if (other.getTopicArn() == null ^ this.getTopicArn() == null) {
            return false;
        }
        if (other.getTopicArn() != null && !other.getTopicArn().equals(this.getTopicArn())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getReturnSubscriptionArn() == null ^ this.getReturnSubscriptionArn() == null) {
            return false;
        }
        return other.getReturnSubscriptionArn() == null || other.getReturnSubscriptionArn().equals(this.getReturnSubscriptionArn());
    }
}

