/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.CreatePlatformEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreatePlatformEndpointRequestMarshaller
implements Marshaller<Request<CreatePlatformEndpointRequest>, CreatePlatformEndpointRequest> {
    public Request<CreatePlatformEndpointRequest> marshall(CreatePlatformEndpointRequest createPlatformEndpointRequest) {
        String prefix;
        if (createPlatformEndpointRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreatePlatformEndpointRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformEndpointRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformEndpoint");
        request.addParameter("Version", "2010-03-31");
        if (createPlatformEndpointRequest.getPlatformApplicationArn() != null) {
            prefix = "PlatformApplicationArn";
            String platformApplicationArn = createPlatformEndpointRequest.getPlatformApplicationArn();
            request.addParameter(prefix, StringUtils.fromString((String)platformApplicationArn));
        }
        if (createPlatformEndpointRequest.getToken() != null) {
            prefix = "Token";
            String token = createPlatformEndpointRequest.getToken();
            request.addParameter(prefix, StringUtils.fromString((String)token));
        }
        if (createPlatformEndpointRequest.getCustomUserData() != null) {
            prefix = "CustomUserData";
            String customUserData = createPlatformEndpointRequest.getCustomUserData();
            request.addParameter(prefix, StringUtils.fromString((String)customUserData));
        }
        if (createPlatformEndpointRequest.getAttributes() != null) {
            prefix = "Attributes";
            Map<String, String> attributes = createPlatformEndpointRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

