/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.CreateTopicRequest;
import com.amazonaws.services.sns.model.Tag;
import com.amazonaws.services.sns.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;
import java.util.Map;

public class CreateTopicRequestMarshaller
implements Marshaller<Request<CreateTopicRequest>, CreateTopicRequest> {
    public Request<CreateTopicRequest> marshall(CreateTopicRequest createTopicRequest) {
        String prefix;
        if (createTopicRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateTopicRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTopicRequest, "AmazonSNS");
        request.addParameter("Action", "CreateTopic");
        request.addParameter("Version", "2010-03-31");
        if (createTopicRequest.getName() != null) {
            prefix = "Name";
            String name = createTopicRequest.getName();
            request.addParameter(prefix, StringUtils.fromString((String)name));
        }
        if (createTopicRequest.getAttributes() != null) {
            prefix = "Attributes";
            Map<String, String> attributes = createTopicRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry entry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (entry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)((String)entry.getKey())));
                }
                prefix = prefix + ".value";
                if (entry.getValue() != null) {
                    String attributesValue = (String)entry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            prefix = attributesPrefix;
        }
        if (createTopicRequest.getTags() != null) {
            prefix = "Tags";
            List<Tag> tags = createTopicRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tag : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tag != null) {
                    TagStaxMarshaller.getInstance().marshall(tag, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

