/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SetEndpointAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetEndpointAttributesRequestMarshaller
implements Marshaller<Request<SetEndpointAttributesRequest>, SetEndpointAttributesRequest> {
    public Request<SetEndpointAttributesRequest> marshall(SetEndpointAttributesRequest setEndpointAttributesRequest) {
        String prefix;
        if (setEndpointAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetEndpointAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setEndpointAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetEndpointAttributes");
        request.addParameter("Version", "2010-03-31");
        if (setEndpointAttributesRequest.getEndpointArn() != null) {
            prefix = "EndpointArn";
            String endpointArn = setEndpointAttributesRequest.getEndpointArn();
            request.addParameter(prefix, StringUtils.fromString((String)endpointArn));
        }
        if (setEndpointAttributesRequest.getAttributes() != null) {
            prefix = "Attributes";
            Map<String, String> attributes = setEndpointAttributesRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

