/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SetSMSAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetSMSAttributesRequestMarshaller
implements Marshaller<Request<SetSMSAttributesRequest>, SetSMSAttributesRequest> {
    public Request<SetSMSAttributesRequest> marshall(SetSMSAttributesRequest setSMSAttributesRequest) {
        if (setSMSAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetSMSAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setSMSAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        if (setSMSAttributesRequest.getAttributes() != null) {
            String prefix = "attributes";
            Map<String, String> attributes = setSMSAttributesRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

