/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.services.sns.model.Subscription;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;

class SubscriptionStaxUnmarshaller
implements Unmarshaller<Subscription, StaxUnmarshallerContext> {
    private static SubscriptionStaxUnmarshaller instance;

    SubscriptionStaxUnmarshaller() {
    }

    public Subscription unmarshall(StaxUnmarshallerContext context) throws Exception {
        int xmlEvent;
        Subscription subscription = new Subscription();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while ((xmlEvent = context.nextEvent()) != 1) {
            if (xmlEvent == 2) {
                if (context.testExpression("SubscriptionArn", targetDepth)) {
                    subscription.setSubscriptionArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Owner", targetDepth)) {
                    subscription.setOwner(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Protocol", targetDepth)) {
                    subscription.setProtocol(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    subscription.setEndpoint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TopicArn", targetDepth)) continue;
                subscription.setTopicArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent != 3 || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return subscription;
    }

    public static SubscriptionStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SubscriptionStaxUnmarshaller();
        }
        return instance;
    }
}

