/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.Tag;
import com.amazonaws.services.sns.model.TagResourceRequest;
import com.amazonaws.services.sns.model.transform.TagStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class TagResourceRequestMarshaller
implements Marshaller<Request<TagResourceRequest>, TagResourceRequest> {
    public Request<TagResourceRequest> marshall(TagResourceRequest tagResourceRequest) {
        String prefix;
        if (tagResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(TagResourceRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)tagResourceRequest, "AmazonSNS");
        request.addParameter("Action", "TagResource");
        request.addParameter("Version", "2010-03-31");
        if (tagResourceRequest.getResourceArn() != null) {
            prefix = "ResourceArn";
            String resourceArn = tagResourceRequest.getResourceArn();
            request.addParameter(prefix, StringUtils.fromString((String)resourceArn));
        }
        if (tagResourceRequest.getTags() != null) {
            prefix = "Tags";
            List<Tag> tags = tagResourceRequest.getTags();
            int tagsIndex = 1;
            String tagsPrefix = prefix;
            for (Tag tagsItem : tags) {
                prefix = tagsPrefix + ".member." + tagsIndex;
                if (tagsItem != null) {
                    TagStaxMarshaller.getInstance().marshall(tagsItem, (Request<?>)request, prefix + ".");
                }
                ++tagsIndex;
            }
            String string = tagsPrefix;
        }
        return request;
    }
}

