/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.services.sqs.model.AddPermissionRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchResult;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.services.sqs.model.CreateQueueResult;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchResult;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.DeleteQueueRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesRequest;
import com.amazonaws.services.sqs.model.GetQueueAttributesResult;
import com.amazonaws.services.sqs.model.GetQueueUrlRequest;
import com.amazonaws.services.sqs.model.GetQueueUrlResult;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesRequest;
import com.amazonaws.services.sqs.model.ListDeadLetterSourceQueuesResult;
import com.amazonaws.services.sqs.model.ListQueuesRequest;
import com.amazonaws.services.sqs.model.ListQueuesResult;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonSQSAsyncClient
extends AmazonSQSClient
implements AmazonSQSAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;

    @Deprecated
    public AmazonSQSAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    @Deprecated
    public AmazonSQSAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(10));
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonSQSAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(10));
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonSQSAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.addPermission(addPermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> addPermissionAsync(final AddPermissionRequest addPermissionRequest, final AsyncHandler<AddPermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.addPermission(addPermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)addPermissionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> changeMessageVisibilityAsync(final ChangeMessageVisibilityRequest changeMessageVisibilityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.changeMessageVisibility(changeMessageVisibilityRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> changeMessageVisibilityAsync(final ChangeMessageVisibilityRequest changeMessageVisibilityRequest, final AsyncHandler<ChangeMessageVisibilityRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.changeMessageVisibility(changeMessageVisibilityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)changeMessageVisibilityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(final ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeMessageVisibilityBatchResult>(){

            @Override
            public ChangeMessageVisibilityBatchResult call() throws Exception {
                return AmazonSQSAsyncClient.this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
            }
        });
    }

    @Override
    public Future<ChangeMessageVisibilityBatchResult> changeMessageVisibilityBatchAsync(final ChangeMessageVisibilityBatchRequest changeMessageVisibilityBatchRequest, final AsyncHandler<ChangeMessageVisibilityBatchRequest, ChangeMessageVisibilityBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ChangeMessageVisibilityBatchResult>(){

            @Override
            public ChangeMessageVisibilityBatchResult call() throws Exception {
                ChangeMessageVisibilityBatchResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.changeMessageVisibilityBatch(changeMessageVisibilityBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)changeMessageVisibilityBatchRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(final CreateQueueRequest createQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                return AmazonSQSAsyncClient.this.createQueue(createQueueRequest);
            }
        });
    }

    @Override
    public Future<CreateQueueResult> createQueueAsync(final CreateQueueRequest createQueueRequest, final AsyncHandler<CreateQueueRequest, CreateQueueResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateQueueResult>(){

            @Override
            public CreateQueueResult call() throws Exception {
                CreateQueueResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.createQueue(createQueueRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createQueueRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteMessageAsync(final DeleteMessageRequest deleteMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.deleteMessage(deleteMessageRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteMessageAsync(final DeleteMessageRequest deleteMessageRequest, final AsyncHandler<DeleteMessageRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.deleteMessage(deleteMessageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteMessageRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(final DeleteMessageBatchRequest deleteMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteMessageBatchResult>(){

            @Override
            public DeleteMessageBatchResult call() throws Exception {
                return AmazonSQSAsyncClient.this.deleteMessageBatch(deleteMessageBatchRequest);
            }
        });
    }

    @Override
    public Future<DeleteMessageBatchResult> deleteMessageBatchAsync(final DeleteMessageBatchRequest deleteMessageBatchRequest, final AsyncHandler<DeleteMessageBatchRequest, DeleteMessageBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeleteMessageBatchResult>(){

            @Override
            public DeleteMessageBatchResult call() throws Exception {
                DeleteMessageBatchResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.deleteMessageBatch(deleteMessageBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteMessageBatchRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteQueueAsync(final DeleteQueueRequest deleteQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.deleteQueue(deleteQueueRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteQueueAsync(final DeleteQueueRequest deleteQueueRequest, final AsyncHandler<DeleteQueueRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.deleteQueue(deleteQueueRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteQueueRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(final GetQueueAttributesRequest getQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueAttributesResult>(){

            @Override
            public GetQueueAttributesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.getQueueAttributes(getQueueAttributesRequest);
            }
        });
    }

    @Override
    public Future<GetQueueAttributesResult> getQueueAttributesAsync(final GetQueueAttributesRequest getQueueAttributesRequest, final AsyncHandler<GetQueueAttributesRequest, GetQueueAttributesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueAttributesResult>(){

            @Override
            public GetQueueAttributesResult call() throws Exception {
                GetQueueAttributesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.getQueueAttributes(getQueueAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getQueueAttributesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(final GetQueueUrlRequest getQueueUrlRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueUrlResult>(){

            @Override
            public GetQueueUrlResult call() throws Exception {
                return AmazonSQSAsyncClient.this.getQueueUrl(getQueueUrlRequest);
            }
        });
    }

    @Override
    public Future<GetQueueUrlResult> getQueueUrlAsync(final GetQueueUrlRequest getQueueUrlRequest, final AsyncHandler<GetQueueUrlRequest, GetQueueUrlResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetQueueUrlResult>(){

            @Override
            public GetQueueUrlResult call() throws Exception {
                GetQueueUrlResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.getQueueUrl(getQueueUrlRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getQueueUrlRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(final ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDeadLetterSourceQueuesResult>(){

            @Override
            public ListDeadLetterSourceQueuesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
            }
        });
    }

    @Override
    public Future<ListDeadLetterSourceQueuesResult> listDeadLetterSourceQueuesAsync(final ListDeadLetterSourceQueuesRequest listDeadLetterSourceQueuesRequest, final AsyncHandler<ListDeadLetterSourceQueuesRequest, ListDeadLetterSourceQueuesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListDeadLetterSourceQueuesResult>(){

            @Override
            public ListDeadLetterSourceQueuesResult call() throws Exception {
                ListDeadLetterSourceQueuesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.listDeadLetterSourceQueues(listDeadLetterSourceQueuesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listDeadLetterSourceQueuesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(final ListQueuesRequest listQueuesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                return AmazonSQSAsyncClient.this.listQueues(listQueuesRequest);
            }
        });
    }

    @Override
    public Future<ListQueuesResult> listQueuesAsync(final ListQueuesRequest listQueuesRequest, final AsyncHandler<ListQueuesRequest, ListQueuesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListQueuesResult>(){

            @Override
            public ListQueuesResult call() throws Exception {
                ListQueuesResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.listQueues(listQueuesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listQueuesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> purgeQueueAsync(final PurgeQueueRequest purgeQueueRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.purgeQueue(purgeQueueRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> purgeQueueAsync(final PurgeQueueRequest purgeQueueRequest, final AsyncHandler<PurgeQueueRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.purgeQueue(purgeQueueRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)purgeQueueRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(final ReceiveMessageRequest receiveMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReceiveMessageResult>(){

            @Override
            public ReceiveMessageResult call() throws Exception {
                return AmazonSQSAsyncClient.this.receiveMessage(receiveMessageRequest);
            }
        });
    }

    @Override
    public Future<ReceiveMessageResult> receiveMessageAsync(final ReceiveMessageRequest receiveMessageRequest, final AsyncHandler<ReceiveMessageRequest, ReceiveMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ReceiveMessageResult>(){

            @Override
            public ReceiveMessageResult call() throws Exception {
                ReceiveMessageResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.receiveMessage(receiveMessageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)receiveMessageRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.removePermission(removePermissionRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> removePermissionAsync(final RemovePermissionRequest removePermissionRequest, final AsyncHandler<RemovePermissionRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.removePermission(removePermissionRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)removePermissionRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(final SendMessageRequest sendMessageRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageResult>(){

            @Override
            public SendMessageResult call() throws Exception {
                return AmazonSQSAsyncClient.this.sendMessage(sendMessageRequest);
            }
        });
    }

    @Override
    public Future<SendMessageResult> sendMessageAsync(final SendMessageRequest sendMessageRequest, final AsyncHandler<SendMessageRequest, SendMessageResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageResult>(){

            @Override
            public SendMessageResult call() throws Exception {
                SendMessageResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.sendMessage(sendMessageRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)sendMessageRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(final SendMessageBatchRequest sendMessageBatchRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageBatchResult>(){

            @Override
            public SendMessageBatchResult call() throws Exception {
                return AmazonSQSAsyncClient.this.sendMessageBatch(sendMessageBatchRequest);
            }
        });
    }

    @Override
    public Future<SendMessageBatchResult> sendMessageBatchAsync(final SendMessageBatchRequest sendMessageBatchRequest, final AsyncHandler<SendMessageBatchRequest, SendMessageBatchResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<SendMessageBatchResult>(){

            @Override
            public SendMessageBatchResult call() throws Exception {
                SendMessageBatchResult result = null;
                try {
                    result = AmazonSQSAsyncClient.this.sendMessageBatch(sendMessageBatchRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)sendMessageBatchRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setQueueAttributesAsync(final SetQueueAttributesRequest setQueueAttributesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonSQSAsyncClient.this.setQueueAttributes(setQueueAttributesRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setQueueAttributesAsync(final SetQueueAttributesRequest setQueueAttributesRequest, final AsyncHandler<SetQueueAttributesRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonSQSAsyncClient.this.setQueueAttributes(setQueueAttributesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)setQueueAttributesRequest, result);
                return result;
            }
        });
    }
}

