/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.SetQueueAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetQueueAttributesRequestMarshaller
implements Marshaller<Request<SetQueueAttributesRequest>, SetQueueAttributesRequest> {
    public Request<SetQueueAttributesRequest> marshall(SetQueueAttributesRequest setQueueAttributesRequest) {
        String prefix;
        if (setQueueAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetQueueAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setQueueAttributesRequest, "AmazonSQS");
        request.addParameter("Action", "SetQueueAttributes");
        request.addParameter("Version", "2012-11-05");
        if (setQueueAttributesRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = setQueueAttributesRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (setQueueAttributesRequest.getAttributes() != null) {
            prefix = "Attribute";
            Map<String, String> attributes = setQueueAttributesRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".Name", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".Value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

