/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.CreateQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreateQueueRequestMarshaller
implements Marshaller<Request<CreateQueueRequest>, CreateQueueRequest> {
    public Request<CreateQueueRequest> marshall(CreateQueueRequest createQueueRequest) {
        String prefix;
        if (createQueueRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreateQueueRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createQueueRequest, "AmazonSQS");
        request.addParameter("Action", "CreateQueue");
        request.addParameter("Version", "2012-11-05");
        if (createQueueRequest.getQueueName() != null) {
            prefix = "QueueName";
            String queueName = createQueueRequest.getQueueName();
            request.addParameter(prefix, StringUtils.fromString((String)queueName));
        }
        if (createQueueRequest.getAttributes() != null) {
            prefix = "Attribute";
            Map<String, String> attributes = createQueueRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".Name", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".Value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

