/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.PurgeQueueRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class PurgeQueueRequestMarshaller
implements Marshaller<Request<PurgeQueueRequest>, PurgeQueueRequest> {
    public Request<PurgeQueueRequest> marshall(PurgeQueueRequest purgeQueueRequest) {
        if (purgeQueueRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PurgeQueueRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purgeQueueRequest, "AmazonSQS");
        request.addParameter("Action", "PurgeQueue");
        request.addParameter("Version", "2012-11-05");
        if (purgeQueueRequest.getQueueUrl() != null) {
            String prefix = "QueueUrl";
            String queueUrl = purgeQueueRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        return request;
    }
}

