/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ReceiveMessageRequestMarshaller
implements Marshaller<Request<ReceiveMessageRequest>, ReceiveMessageRequest> {
    public Request<ReceiveMessageRequest> marshall(ReceiveMessageRequest receiveMessageRequest) {
        String prefix;
        if (receiveMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ReceiveMessageRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)receiveMessageRequest, "AmazonSQS");
        request.addParameter("Action", "ReceiveMessage");
        request.addParameter("Version", "2012-11-05");
        if (receiveMessageRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = receiveMessageRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (receiveMessageRequest.getAttributeNames() != null) {
            prefix = "AttributeName";
            List<String> attributeNames = receiveMessageRequest.getAttributeNames();
            int attributeNamesIndex = 1;
            String attributeNamesPrefix = prefix;
            for (String attributeNamesItem : attributeNames) {
                prefix = attributeNamesPrefix + "." + attributeNamesIndex;
                if (attributeNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)attributeNamesItem));
                }
                ++attributeNamesIndex;
            }
            prefix = attributeNamesPrefix;
        }
        if (receiveMessageRequest.getMessageAttributeNames() != null) {
            prefix = "MessageAttributeName";
            List<String> messageAttributeNames = receiveMessageRequest.getMessageAttributeNames();
            int messageAttributeNamesIndex = 1;
            String messageAttributeNamesPrefix = prefix;
            for (String messageAttributeNamesItem : messageAttributeNames) {
                prefix = messageAttributeNamesPrefix + "." + messageAttributeNamesIndex;
                if (messageAttributeNamesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)messageAttributeNamesItem));
                }
                ++messageAttributeNamesIndex;
            }
            prefix = messageAttributeNamesPrefix;
        }
        if (receiveMessageRequest.getMaxNumberOfMessages() != null) {
            prefix = "MaxNumberOfMessages";
            Integer maxNumberOfMessages = receiveMessageRequest.getMaxNumberOfMessages();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)maxNumberOfMessages));
        }
        if (receiveMessageRequest.getVisibilityTimeout() != null) {
            prefix = "VisibilityTimeout";
            Integer visibilityTimeout = receiveMessageRequest.getVisibilityTimeout();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)visibilityTimeout));
        }
        if (receiveMessageRequest.getWaitTimeSeconds() != null) {
            prefix = "WaitTimeSeconds";
            Integer waitTimeSeconds = receiveMessageRequest.getWaitTimeSeconds();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)waitTimeSeconds));
        }
        if (receiveMessageRequest.getReceiveRequestAttemptId() != null) {
            prefix = "ReceiveRequestAttemptId";
            String receiveRequestAttemptId = receiveMessageRequest.getReceiveRequestAttemptId();
            request.addParameter(prefix, StringUtils.fromString((String)receiveRequestAttemptId));
        }
        return request;
    }
}

