/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.transform.MessageAttributeValueStaxMarshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

class MessageStaxMarshaller {
    private static MessageStaxMarshaller instance;

    MessageStaxMarshaller() {
    }

    public void marshall(Message _message, Request<?> request, String _prefix) {
        String prefix;
        if (_message.getMessageId() != null) {
            prefix = _prefix + "MessageId";
            String messageId = _message.getMessageId();
            request.addParameter(prefix, StringUtils.fromString((String)messageId));
        }
        if (_message.getReceiptHandle() != null) {
            prefix = _prefix + "ReceiptHandle";
            String receiptHandle = _message.getReceiptHandle();
            request.addParameter(prefix, StringUtils.fromString((String)receiptHandle));
        }
        if (_message.getMD5OfBody() != null) {
            prefix = _prefix + "MD5OfBody";
            String mD5OfBody = _message.getMD5OfBody();
            request.addParameter(prefix, StringUtils.fromString((String)mD5OfBody));
        }
        if (_message.getBody() != null) {
            prefix = _prefix + "Body";
            String body = _message.getBody();
            request.addParameter(prefix, StringUtils.fromString((String)body));
        }
        if (_message.getAttributes() != null) {
            prefix = _prefix + "Attribute";
            Map<String, String> attributes = _message.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".";
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (entry.getKey() != null) {
                    request.addParameter(prefix + ".Name", StringUtils.fromString((String)entry.getKey()));
                }
                prefix = prefix + ".Value";
                if (entry.getValue() != null) {
                    String attributesValue = entry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            prefix = attributesPrefix;
        }
        if (_message.getMD5OfMessageAttributes() != null) {
            prefix = _prefix + "MD5OfMessageAttributes";
            String mD5OfMessageAttributes = _message.getMD5OfMessageAttributes();
            request.addParameter(prefix, StringUtils.fromString((String)mD5OfMessageAttributes));
        }
        if (_message.getMessageAttributes() != null) {
            prefix = _prefix + "MessageAttribute";
            Map<String, MessageAttributeValue> messageAttributes = _message.getMessageAttributes();
            int messageAttributesIndex = 1;
            String messageAttributesPrefix = prefix + ".";
            for (Map.Entry<String, Object> entry : messageAttributes.entrySet()) {
                prefix = messageAttributesPrefix + messageAttributesIndex;
                if (entry.getKey() != null) {
                    request.addParameter(prefix + ".Name", StringUtils.fromString((String)entry.getKey()));
                }
                prefix = prefix + ".Value";
                if (entry.getValue() != null) {
                    MessageAttributeValue messageAttributesValue = (MessageAttributeValue)entry.getValue();
                    MessageAttributeValueStaxMarshaller.getInstance().marshall(messageAttributesValue, request, prefix + ".");
                }
                ++messageAttributesIndex;
            }
            prefix = messageAttributesPrefix;
        }
    }

    public static MessageStaxMarshaller getInstance() {
        if (instance == null) {
            instance = new MessageStaxMarshaller();
        }
        return instance;
    }
}

