/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.transform.MessageAttributeValueStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SendMessageRequestMarshaller
implements Marshaller<Request<SendMessageRequest>, SendMessageRequest> {
    public Request<SendMessageRequest> marshall(SendMessageRequest sendMessageRequest) {
        String prefix;
        if (sendMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SendMessageRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)sendMessageRequest, "AmazonSQS");
        request.addParameter("Action", "SendMessage");
        request.addParameter("Version", "2012-11-05");
        if (sendMessageRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = sendMessageRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (sendMessageRequest.getMessageBody() != null) {
            prefix = "MessageBody";
            String messageBody = sendMessageRequest.getMessageBody();
            request.addParameter(prefix, StringUtils.fromString((String)messageBody));
        }
        if (sendMessageRequest.getDelaySeconds() != null) {
            prefix = "DelaySeconds";
            Integer delaySeconds = sendMessageRequest.getDelaySeconds();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)delaySeconds));
        }
        if (sendMessageRequest.getMessageAttributes() != null) {
            prefix = "MessageAttribute";
            Map<String, MessageAttributeValue> messageAttributes = sendMessageRequest.getMessageAttributes();
            int messageAttributesIndex = 1;
            String messageAttributesPrefix = prefix + ".";
            for (Map.Entry<String, MessageAttributeValue> messageAttributesEntry : messageAttributes.entrySet()) {
                prefix = messageAttributesPrefix + messageAttributesIndex;
                if (messageAttributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".Name", StringUtils.fromString((String)messageAttributesEntry.getKey()));
                }
                prefix = prefix + ".Value";
                if (messageAttributesEntry.getValue() != null) {
                    MessageAttributeValue messageAttributesValue = messageAttributesEntry.getValue();
                    MessageAttributeValueStaxMarshaller.getInstance().marshall(messageAttributesValue, (Request<?>)request, prefix + ".");
                }
                ++messageAttributesIndex;
            }
            prefix = messageAttributesPrefix;
        }
        if (sendMessageRequest.getMessageDeduplicationId() != null) {
            prefix = "MessageDeduplicationId";
            String messageDeduplicationId = sendMessageRequest.getMessageDeduplicationId();
            request.addParameter(prefix, StringUtils.fromString((String)messageDeduplicationId));
        }
        if (sendMessageRequest.getMessageGroupId() != null) {
            prefix = "MessageGroupId";
            String messageGroupId = sendMessageRequest.getMessageGroupId();
            request.addParameter(prefix, StringUtils.fromString((String)messageGroupId));
        }
        return request;
    }
}

