/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class MediaJsonUnmarshaller
implements Unmarshaller<Media, JsonUnmarshallerContext> {
    private static MediaJsonUnmarshaller instance;

    MediaJsonUnmarshaller() {
    }

    public Media unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        Media media = new Media();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("MediaFileUri")) {
                media.setMediaFileUri(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return media;
    }

    public static MediaJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MediaJsonUnmarshaller();
        }
        return instance;
    }
}

