/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.ListVocabulariesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListVocabulariesRequestMarshaller
implements Marshaller<Request<ListVocabulariesRequest>, ListVocabulariesRequest> {
    public Request<ListVocabulariesRequest> marshall(ListVocabulariesRequest listVocabulariesRequest) {
        if (listVocabulariesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListVocabulariesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listVocabulariesRequest, "AmazonTranscribe");
        String target = "Transcribe.ListVocabularies";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listVocabulariesRequest.getNextToken() != null) {
                String nextToken = listVocabulariesRequest.getNextToken();
                jsonWriter.name("NextToken");
                jsonWriter.value(nextToken);
            }
            if (listVocabulariesRequest.getMaxResults() != null) {
                Integer maxResults = listVocabulariesRequest.getMaxResults();
                jsonWriter.name("MaxResults");
                jsonWriter.value((Number)maxResults);
            }
            if (listVocabulariesRequest.getStateEquals() != null) {
                String stateEquals = listVocabulariesRequest.getStateEquals();
                jsonWriter.name("StateEquals");
                jsonWriter.value(stateEquals);
            }
            if (listVocabulariesRequest.getNameContains() != null) {
                String nameContains = listVocabulariesRequest.getNameContains();
                jsonWriter.name("NameContains");
                jsonWriter.value(nameContains);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

