/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.services.transcribe.model.Settings;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class SettingsJsonUnmarshaller
implements Unmarshaller<Settings, JsonUnmarshallerContext> {
    private static SettingsJsonUnmarshaller instance;

    SettingsJsonUnmarshaller() {
    }

    public Settings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        Settings settings = new Settings();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("VocabularyName")) {
                settings.setVocabularyName(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ShowSpeakerLabels")) {
                settings.setShowSpeakerLabels(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("MaxSpeakerLabels")) {
                settings.setMaxSpeakerLabels(SimpleTypeJsonUnmarshallers.IntegerJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("ChannelIdentification")) {
                settings.setChannelIdentification(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return settings;
    }

    public static SettingsJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SettingsJsonUnmarshaller();
        }
        return instance;
    }
}

