/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.UpdateVocabularyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class UpdateVocabularyRequestMarshaller
implements Marshaller<Request<UpdateVocabularyRequest>, UpdateVocabularyRequest> {
    public Request<UpdateVocabularyRequest> marshall(UpdateVocabularyRequest updateVocabularyRequest) {
        if (updateVocabularyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UpdateVocabularyRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateVocabularyRequest, "AmazonTranscribe");
        String target = "Transcribe.UpdateVocabulary";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (updateVocabularyRequest.getVocabularyName() != null) {
                String vocabularyName = updateVocabularyRequest.getVocabularyName();
                jsonWriter.name("VocabularyName");
                jsonWriter.value(vocabularyName);
            }
            if (updateVocabularyRequest.getLanguageCode() != null) {
                String languageCode = updateVocabularyRequest.getLanguageCode();
                jsonWriter.name("LanguageCode");
                jsonWriter.value(languageCode);
            }
            if (updateVocabularyRequest.getPhrases() != null) {
                List<String> phrases = updateVocabularyRequest.getPhrases();
                jsonWriter.name("Phrases");
                jsonWriter.beginArray();
                for (String phrasesItem : phrases) {
                    if (phrasesItem == null) continue;
                    jsonWriter.value(phrasesItem);
                }
                jsonWriter.endArray();
            }
            if (updateVocabularyRequest.getVocabularyFileUri() != null) {
                String vocabularyFileUri = updateVocabularyRequest.getVocabularyFileUri();
                jsonWriter.name("VocabularyFileUri");
                jsonWriter.value(vocabularyFileUri);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

