/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.transcribe.AmazonTranscribeAsync;
import com.amazonaws.services.transcribe.AmazonTranscribeClient;
import com.amazonaws.services.transcribe.model.CreateVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.CreateVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.CreateVocabularyRequest;
import com.amazonaws.services.transcribe.model.CreateVocabularyResult;
import com.amazonaws.services.transcribe.model.DeleteTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.DeleteVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.DeleteVocabularyRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.GetVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.GetVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.GetVocabularyRequest;
import com.amazonaws.services.transcribe.model.GetVocabularyResult;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsRequest;
import com.amazonaws.services.transcribe.model.ListTranscriptionJobsResult;
import com.amazonaws.services.transcribe.model.ListVocabulariesRequest;
import com.amazonaws.services.transcribe.model.ListVocabulariesResult;
import com.amazonaws.services.transcribe.model.ListVocabularyFiltersRequest;
import com.amazonaws.services.transcribe.model.ListVocabularyFiltersResult;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.UpdateVocabularyFilterRequest;
import com.amazonaws.services.transcribe.model.UpdateVocabularyFilterResult;
import com.amazonaws.services.transcribe.model.UpdateVocabularyRequest;
import com.amazonaws.services.transcribe.model.UpdateVocabularyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonTranscribeAsyncClient
extends AmazonTranscribeClient
implements AmazonTranscribeAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 10;

    @Deprecated
    public AmazonTranscribeAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    @Deprecated
    public AmazonTranscribeAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonTranscribeAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(10));
    }

    public AmazonTranscribeAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonTranscribeAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonTranscribeAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(10));
    }

    public AmazonTranscribeAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonTranscribeAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonTranscribeAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<CreateVocabularyResult> createVocabularyAsync(final CreateVocabularyRequest createVocabularyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVocabularyResult>(){

            @Override
            public CreateVocabularyResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.createVocabulary(createVocabularyRequest);
            }
        });
    }

    @Override
    public Future<CreateVocabularyResult> createVocabularyAsync(final CreateVocabularyRequest createVocabularyRequest, final AsyncHandler<CreateVocabularyRequest, CreateVocabularyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVocabularyResult>(){

            @Override
            public CreateVocabularyResult call() throws Exception {
                CreateVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.createVocabulary(createVocabularyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createVocabularyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<CreateVocabularyFilterResult> createVocabularyFilterAsync(final CreateVocabularyFilterRequest createVocabularyFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVocabularyFilterResult>(){

            @Override
            public CreateVocabularyFilterResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.createVocabularyFilter(createVocabularyFilterRequest);
            }
        });
    }

    @Override
    public Future<CreateVocabularyFilterResult> createVocabularyFilterAsync(final CreateVocabularyFilterRequest createVocabularyFilterRequest, final AsyncHandler<CreateVocabularyFilterRequest, CreateVocabularyFilterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CreateVocabularyFilterResult>(){

            @Override
            public CreateVocabularyFilterResult call() throws Exception {
                CreateVocabularyFilterResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.createVocabularyFilter(createVocabularyFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)createVocabularyFilterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteTranscriptionJobAsync(final DeleteTranscriptionJobRequest deleteTranscriptionJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonTranscribeAsyncClient.this.deleteTranscriptionJob(deleteTranscriptionJobRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteTranscriptionJobAsync(final DeleteTranscriptionJobRequest deleteTranscriptionJobRequest, final AsyncHandler<DeleteTranscriptionJobRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonTranscribeAsyncClient.this.deleteTranscriptionJob(deleteTranscriptionJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteTranscriptionJobRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVocabularyAsync(final DeleteVocabularyRequest deleteVocabularyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonTranscribeAsyncClient.this.deleteVocabulary(deleteVocabularyRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVocabularyAsync(final DeleteVocabularyRequest deleteVocabularyRequest, final AsyncHandler<DeleteVocabularyRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonTranscribeAsyncClient.this.deleteVocabulary(deleteVocabularyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteVocabularyRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> deleteVocabularyFilterAsync(final DeleteVocabularyFilterRequest deleteVocabularyFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonTranscribeAsyncClient.this.deleteVocabularyFilter(deleteVocabularyFilterRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteVocabularyFilterAsync(final DeleteVocabularyFilterRequest deleteVocabularyFilterRequest, final AsyncHandler<DeleteVocabularyFilterRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Void result = null;
                try {
                    AmazonTranscribeAsyncClient.this.deleteVocabularyFilter(deleteVocabularyFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)deleteVocabularyFilterRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetTranscriptionJobResult> getTranscriptionJobAsync(final GetTranscriptionJobRequest getTranscriptionJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTranscriptionJobResult>(){

            @Override
            public GetTranscriptionJobResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.getTranscriptionJob(getTranscriptionJobRequest);
            }
        });
    }

    @Override
    public Future<GetTranscriptionJobResult> getTranscriptionJobAsync(final GetTranscriptionJobRequest getTranscriptionJobRequest, final AsyncHandler<GetTranscriptionJobRequest, GetTranscriptionJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetTranscriptionJobResult>(){

            @Override
            public GetTranscriptionJobResult call() throws Exception {
                GetTranscriptionJobResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.getTranscriptionJob(getTranscriptionJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getTranscriptionJobRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetVocabularyResult> getVocabularyAsync(final GetVocabularyRequest getVocabularyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetVocabularyResult>(){

            @Override
            public GetVocabularyResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.getVocabulary(getVocabularyRequest);
            }
        });
    }

    @Override
    public Future<GetVocabularyResult> getVocabularyAsync(final GetVocabularyRequest getVocabularyRequest, final AsyncHandler<GetVocabularyRequest, GetVocabularyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetVocabularyResult>(){

            @Override
            public GetVocabularyResult call() throws Exception {
                GetVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.getVocabulary(getVocabularyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getVocabularyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<GetVocabularyFilterResult> getVocabularyFilterAsync(final GetVocabularyFilterRequest getVocabularyFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetVocabularyFilterResult>(){

            @Override
            public GetVocabularyFilterResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.getVocabularyFilter(getVocabularyFilterRequest);
            }
        });
    }

    @Override
    public Future<GetVocabularyFilterResult> getVocabularyFilterAsync(final GetVocabularyFilterRequest getVocabularyFilterRequest, final AsyncHandler<GetVocabularyFilterRequest, GetVocabularyFilterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetVocabularyFilterResult>(){

            @Override
            public GetVocabularyFilterResult call() throws Exception {
                GetVocabularyFilterResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.getVocabularyFilter(getVocabularyFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)getVocabularyFilterRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListTranscriptionJobsResult> listTranscriptionJobsAsync(final ListTranscriptionJobsRequest listTranscriptionJobsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTranscriptionJobsResult>(){

            @Override
            public ListTranscriptionJobsResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.listTranscriptionJobs(listTranscriptionJobsRequest);
            }
        });
    }

    @Override
    public Future<ListTranscriptionJobsResult> listTranscriptionJobsAsync(final ListTranscriptionJobsRequest listTranscriptionJobsRequest, final AsyncHandler<ListTranscriptionJobsRequest, ListTranscriptionJobsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListTranscriptionJobsResult>(){

            @Override
            public ListTranscriptionJobsResult call() throws Exception {
                ListTranscriptionJobsResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.listTranscriptionJobs(listTranscriptionJobsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listTranscriptionJobsRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListVocabulariesResult> listVocabulariesAsync(final ListVocabulariesRequest listVocabulariesRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVocabulariesResult>(){

            @Override
            public ListVocabulariesResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.listVocabularies(listVocabulariesRequest);
            }
        });
    }

    @Override
    public Future<ListVocabulariesResult> listVocabulariesAsync(final ListVocabulariesRequest listVocabulariesRequest, final AsyncHandler<ListVocabulariesRequest, ListVocabulariesResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVocabulariesResult>(){

            @Override
            public ListVocabulariesResult call() throws Exception {
                ListVocabulariesResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.listVocabularies(listVocabulariesRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listVocabulariesRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<ListVocabularyFiltersResult> listVocabularyFiltersAsync(final ListVocabularyFiltersRequest listVocabularyFiltersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVocabularyFiltersResult>(){

            @Override
            public ListVocabularyFiltersResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.listVocabularyFilters(listVocabularyFiltersRequest);
            }
        });
    }

    @Override
    public Future<ListVocabularyFiltersResult> listVocabularyFiltersAsync(final ListVocabularyFiltersRequest listVocabularyFiltersRequest, final AsyncHandler<ListVocabularyFiltersRequest, ListVocabularyFiltersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ListVocabularyFiltersResult>(){

            @Override
            public ListVocabularyFiltersResult call() throws Exception {
                ListVocabularyFiltersResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.listVocabularyFilters(listVocabularyFiltersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)listVocabularyFiltersRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<StartTranscriptionJobResult> startTranscriptionJobAsync(final StartTranscriptionJobRequest startTranscriptionJobRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartTranscriptionJobResult>(){

            @Override
            public StartTranscriptionJobResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.startTranscriptionJob(startTranscriptionJobRequest);
            }
        });
    }

    @Override
    public Future<StartTranscriptionJobResult> startTranscriptionJobAsync(final StartTranscriptionJobRequest startTranscriptionJobRequest, final AsyncHandler<StartTranscriptionJobRequest, StartTranscriptionJobResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<StartTranscriptionJobResult>(){

            @Override
            public StartTranscriptionJobResult call() throws Exception {
                StartTranscriptionJobResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.startTranscriptionJob(startTranscriptionJobRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)startTranscriptionJobRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVocabularyResult> updateVocabularyAsync(final UpdateVocabularyRequest updateVocabularyRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateVocabularyResult>(){

            @Override
            public UpdateVocabularyResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.updateVocabulary(updateVocabularyRequest);
            }
        });
    }

    @Override
    public Future<UpdateVocabularyResult> updateVocabularyAsync(final UpdateVocabularyRequest updateVocabularyRequest, final AsyncHandler<UpdateVocabularyRequest, UpdateVocabularyResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateVocabularyResult>(){

            @Override
            public UpdateVocabularyResult call() throws Exception {
                UpdateVocabularyResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.updateVocabulary(updateVocabularyRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateVocabularyRequest, (Object)result);
                return result;
            }
        });
    }

    @Override
    public Future<UpdateVocabularyFilterResult> updateVocabularyFilterAsync(final UpdateVocabularyFilterRequest updateVocabularyFilterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateVocabularyFilterResult>(){

            @Override
            public UpdateVocabularyFilterResult call() throws Exception {
                return AmazonTranscribeAsyncClient.this.updateVocabularyFilter(updateVocabularyFilterRequest);
            }
        });
    }

    @Override
    public Future<UpdateVocabularyFilterResult> updateVocabularyFilterAsync(final UpdateVocabularyFilterRequest updateVocabularyFilterRequest, final AsyncHandler<UpdateVocabularyFilterRequest, UpdateVocabularyFilterResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<UpdateVocabularyFilterResult>(){

            @Override
            public UpdateVocabularyFilterResult call() throws Exception {
                UpdateVocabularyFilterResult result = null;
                try {
                    result = AmazonTranscribeAsyncClient.this.updateVocabularyFilter(updateVocabularyFilterRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess((AmazonWebServiceRequest)updateVocabularyFilterRequest, (Object)result);
                return result;
            }
        });
    }
}

