/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateVocabularyFilterRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String vocabularyFilterName;
    private List<String> words;
    private String vocabularyFilterFileUri;

    public String getVocabularyFilterName() {
        return this.vocabularyFilterName;
    }

    public void setVocabularyFilterName(String vocabularyFilterName) {
        this.vocabularyFilterName = vocabularyFilterName;
    }

    public UpdateVocabularyFilterRequest withVocabularyFilterName(String vocabularyFilterName) {
        this.vocabularyFilterName = vocabularyFilterName;
        return this;
    }

    public List<String> getWords() {
        return this.words;
    }

    public void setWords(Collection<String> words) {
        if (words == null) {
            this.words = null;
            return;
        }
        this.words = new ArrayList<String>(words);
    }

    public UpdateVocabularyFilterRequest withWords(String ... words) {
        if (this.getWords() == null) {
            this.words = new ArrayList<String>(words.length);
        }
        for (String value : words) {
            this.words.add(value);
        }
        return this;
    }

    public UpdateVocabularyFilterRequest withWords(Collection<String> words) {
        this.setWords(words);
        return this;
    }

    public String getVocabularyFilterFileUri() {
        return this.vocabularyFilterFileUri;
    }

    public void setVocabularyFilterFileUri(String vocabularyFilterFileUri) {
        this.vocabularyFilterFileUri = vocabularyFilterFileUri;
    }

    public UpdateVocabularyFilterRequest withVocabularyFilterFileUri(String vocabularyFilterFileUri) {
        this.vocabularyFilterFileUri = vocabularyFilterFileUri;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVocabularyFilterName() != null) {
            sb.append("VocabularyFilterName: " + this.getVocabularyFilterName() + ",");
        }
        if (this.getWords() != null) {
            sb.append("Words: " + this.getWords() + ",");
        }
        if (this.getVocabularyFilterFileUri() != null) {
            sb.append("VocabularyFilterFileUri: " + this.getVocabularyFilterFileUri());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVocabularyFilterName() == null ? 0 : this.getVocabularyFilterName().hashCode());
        hashCode = 31 * hashCode + (this.getWords() == null ? 0 : this.getWords().hashCode());
        hashCode = 31 * hashCode + (this.getVocabularyFilterFileUri() == null ? 0 : this.getVocabularyFilterFileUri().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVocabularyFilterRequest)) {
            return false;
        }
        UpdateVocabularyFilterRequest other = (UpdateVocabularyFilterRequest)obj;
        if (other.getVocabularyFilterName() == null ^ this.getVocabularyFilterName() == null) {
            return false;
        }
        if (other.getVocabularyFilterName() != null && !other.getVocabularyFilterName().equals(this.getVocabularyFilterName())) {
            return false;
        }
        if (other.getWords() == null ^ this.getWords() == null) {
            return false;
        }
        if (other.getWords() != null && !other.getWords().equals(this.getWords())) {
            return false;
        }
        if (other.getVocabularyFilterFileUri() == null ^ this.getVocabularyFilterFileUri() == null) {
            return false;
        }
        return other.getVocabularyFilterFileUri() == null || other.getVocabularyFilterFileUri().equals(this.getVocabularyFilterFileUri());
    }
}

