/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.services.transcribe.model.JobExecutionSettings;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.AwsJsonReader;

class JobExecutionSettingsJsonUnmarshaller
implements Unmarshaller<JobExecutionSettings, JsonUnmarshallerContext> {
    private static JobExecutionSettingsJsonUnmarshaller instance;

    JobExecutionSettingsJsonUnmarshaller() {
    }

    public JobExecutionSettings unmarshall(JsonUnmarshallerContext context) throws Exception {
        AwsJsonReader reader = context.getReader();
        if (!reader.isContainer()) {
            reader.skipValue();
            return null;
        }
        JobExecutionSettings jobExecutionSettings = new JobExecutionSettings();
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("AllowDeferredExecution")) {
                jobExecutionSettings.setAllowDeferredExecution(SimpleTypeJsonUnmarshallers.BooleanJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (name.equals("DataAccessRoleArn")) {
                jobExecutionSettings.setDataAccessRoleArn(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return jobExecutionSettings;
    }

    public static JobExecutionSettingsJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new JobExecutionSettingsJsonUnmarshaller();
        }
        return instance;
    }
}

