/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.ListVocabularyFiltersRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class ListVocabularyFiltersRequestMarshaller
implements Marshaller<Request<ListVocabularyFiltersRequest>, ListVocabularyFiltersRequest> {
    public Request<ListVocabularyFiltersRequest> marshall(ListVocabularyFiltersRequest listVocabularyFiltersRequest) {
        if (listVocabularyFiltersRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ListVocabularyFiltersRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listVocabularyFiltersRequest, "AmazonTranscribe");
        String target = "Transcribe.ListVocabularyFilters";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (listVocabularyFiltersRequest.getNextToken() != null) {
                String nextToken = listVocabularyFiltersRequest.getNextToken();
                jsonWriter.name("NextToken");
                jsonWriter.value(nextToken);
            }
            if (listVocabularyFiltersRequest.getMaxResults() != null) {
                Integer maxResults = listVocabularyFiltersRequest.getMaxResults();
                jsonWriter.name("MaxResults");
                jsonWriter.value((Number)maxResults);
            }
            if (listVocabularyFiltersRequest.getNameContains() != null) {
                String nameContains = listVocabularyFiltersRequest.getNameContains();
                jsonWriter.name("NameContains");
                jsonWriter.value(nameContains);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

