/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.services.transcribe.model.Settings;
import com.amazonaws.util.json.AwsJsonWriter;

class SettingsJsonMarshaller {
    private static SettingsJsonMarshaller instance;

    SettingsJsonMarshaller() {
    }

    public void marshall(Settings settings, AwsJsonWriter jsonWriter) throws Exception {
        jsonWriter.beginObject();
        if (settings.getVocabularyName() != null) {
            String vocabularyName = settings.getVocabularyName();
            jsonWriter.name("VocabularyName");
            jsonWriter.value(vocabularyName);
        }
        if (settings.getShowSpeakerLabels() != null) {
            Boolean showSpeakerLabels = settings.getShowSpeakerLabels();
            jsonWriter.name("ShowSpeakerLabels");
            jsonWriter.value(showSpeakerLabels.booleanValue());
        }
        if (settings.getMaxSpeakerLabels() != null) {
            Integer maxSpeakerLabels = settings.getMaxSpeakerLabels();
            jsonWriter.name("MaxSpeakerLabels");
            jsonWriter.value((Number)maxSpeakerLabels);
        }
        if (settings.getChannelIdentification() != null) {
            Boolean channelIdentification = settings.getChannelIdentification();
            jsonWriter.name("ChannelIdentification");
            jsonWriter.value(channelIdentification.booleanValue());
        }
        if (settings.getShowAlternatives() != null) {
            Boolean showAlternatives = settings.getShowAlternatives();
            jsonWriter.name("ShowAlternatives");
            jsonWriter.value(showAlternatives.booleanValue());
        }
        if (settings.getMaxAlternatives() != null) {
            Integer maxAlternatives = settings.getMaxAlternatives();
            jsonWriter.name("MaxAlternatives");
            jsonWriter.value((Number)maxAlternatives);
        }
        if (settings.getVocabularyFilterName() != null) {
            String vocabularyFilterName = settings.getVocabularyFilterName();
            jsonWriter.name("VocabularyFilterName");
            jsonWriter.value(vocabularyFilterName);
        }
        if (settings.getVocabularyFilterMethod() != null) {
            String vocabularyFilterMethod = settings.getVocabularyFilterMethod();
            jsonWriter.name("VocabularyFilterMethod");
            jsonWriter.value(vocabularyFilterMethod);
        }
        jsonWriter.endObject();
    }

    public static SettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SettingsJsonMarshaller();
        }
        return instance;
    }
}

