/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.transcribe.model.JobExecutionSettings;
import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.Settings;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.transform.JobExecutionSettingsJsonMarshaller;
import com.amazonaws.services.transcribe.model.transform.MediaJsonMarshaller;
import com.amazonaws.services.transcribe.model.transform.SettingsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.AwsJsonWriter;
import com.amazonaws.util.json.JsonUtils;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class StartTranscriptionJobRequestMarshaller
implements Marshaller<Request<StartTranscriptionJobRequest>, StartTranscriptionJobRequest> {
    public Request<StartTranscriptionJobRequest> marshall(StartTranscriptionJobRequest startTranscriptionJobRequest) {
        if (startTranscriptionJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(StartTranscriptionJobRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)startTranscriptionJobRequest, "AmazonTranscribe");
        String target = "Transcribe.StartTranscriptionJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/";
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            AwsJsonWriter jsonWriter = JsonUtils.getJsonWriter((Writer)stringWriter);
            jsonWriter.beginObject();
            if (startTranscriptionJobRequest.getTranscriptionJobName() != null) {
                String transcriptionJobName = startTranscriptionJobRequest.getTranscriptionJobName();
                jsonWriter.name("TranscriptionJobName");
                jsonWriter.value(transcriptionJobName);
            }
            if (startTranscriptionJobRequest.getLanguageCode() != null) {
                String languageCode = startTranscriptionJobRequest.getLanguageCode();
                jsonWriter.name("LanguageCode");
                jsonWriter.value(languageCode);
            }
            if (startTranscriptionJobRequest.getMediaSampleRateHertz() != null) {
                Integer mediaSampleRateHertz = startTranscriptionJobRequest.getMediaSampleRateHertz();
                jsonWriter.name("MediaSampleRateHertz");
                jsonWriter.value((Number)mediaSampleRateHertz);
            }
            if (startTranscriptionJobRequest.getMediaFormat() != null) {
                String mediaFormat = startTranscriptionJobRequest.getMediaFormat();
                jsonWriter.name("MediaFormat");
                jsonWriter.value(mediaFormat);
            }
            if (startTranscriptionJobRequest.getMedia() != null) {
                Media media = startTranscriptionJobRequest.getMedia();
                jsonWriter.name("Media");
                MediaJsonMarshaller.getInstance().marshall(media, jsonWriter);
            }
            if (startTranscriptionJobRequest.getOutputBucketName() != null) {
                String outputBucketName = startTranscriptionJobRequest.getOutputBucketName();
                jsonWriter.name("OutputBucketName");
                jsonWriter.value(outputBucketName);
            }
            if (startTranscriptionJobRequest.getOutputEncryptionKMSKeyId() != null) {
                String outputEncryptionKMSKeyId = startTranscriptionJobRequest.getOutputEncryptionKMSKeyId();
                jsonWriter.name("OutputEncryptionKMSKeyId");
                jsonWriter.value(outputEncryptionKMSKeyId);
            }
            if (startTranscriptionJobRequest.getSettings() != null) {
                Settings settings = startTranscriptionJobRequest.getSettings();
                jsonWriter.name("Settings");
                SettingsJsonMarshaller.getInstance().marshall(settings, jsonWriter);
            }
            if (startTranscriptionJobRequest.getJobExecutionSettings() != null) {
                JobExecutionSettings jobExecutionSettings = startTranscriptionJobRequest.getJobExecutionSettings();
                jsonWriter.name("JobExecutionSettings");
                JobExecutionSettingsJsonMarshaller.getInstance().marshall(jobExecutionSettings, jsonWriter);
            }
            jsonWriter.endObject();
            jsonWriter.close();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        return request;
    }
}

